<?php
/**
* 404 Page Settings.
*
* @package Skin Care Solutions
*/

$skin_care_solutions_default = skin_care_solutions_get_default_theme_options();

$wp_customize->add_section( 'skin_care_solutions_404_page_settings',
    array(
        'title'      => esc_html__( '404 Page Settings', 'skin-care-solutions' ),
        'priority'   => 200,
        'capability' => 'edit_theme_options',
        'panel'      => 'skin_care_solutions_theme_addons_panel',
    )
);

$wp_customize->add_setting( 'skin_care_solutions_404_main_title',
    array(
        'default'           => $skin_care_solutions_default['skin_care_solutions_404_main_title'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'skin_care_solutions_404_main_title',
    array(
        'label'    => esc_html__( '404 Main Title', 'skin-care-solutions' ),
        'section'  => 'skin_care_solutions_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'skin_care_solutions_404_subtitle_one',
    array(
        'default'           => $skin_care_solutions_default['skin_care_solutions_404_subtitle_one'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'skin_care_solutions_404_subtitle_one',
    array(
        'label'    => esc_html__( '404 Sub Title One', 'skin-care-solutions' ),
        'section'  => 'skin_care_solutions_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'skin_care_solutions_404_para_one',
    array(
        'default'           => $skin_care_solutions_default['skin_care_solutions_404_para_one'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'skin_care_solutions_404_para_one',
    array(
        'label'    => esc_html__( '404 Para Text One', 'skin-care-solutions' ),
        'section'  => 'skin_care_solutions_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'skin_care_solutions_404_subtitle_two',
    array(
        'default'           => $skin_care_solutions_default['skin_care_solutions_404_subtitle_two'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'skin_care_solutions_404_subtitle_two',
    array(
        'label'    => esc_html__( '404 Sub Title Two', 'skin-care-solutions' ),
        'section'  => 'skin_care_solutions_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'skin_care_solutions_404_para_two',
    array(
        'default'           => $skin_care_solutions_default['skin_care_solutions_404_para_two'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'skin_care_solutions_404_para_two',
    array(
        'label'    => esc_html__( '404 Para Text Two', 'skin-care-solutions' ),
        'section'  => 'skin_care_solutions_404_page_settings',
        'type'     => 'text',
    )
);