<?php
/**
 * Exit if accessed directly.
 *
 * @package Responsive
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Define constants.
 */
define( 'RESPONSIVE_THEME_VERSION', '4.9.5' );
define( 'RESPONSIVE_THEME_DIR', trailingslashit( get_template_directory() ) );
define( 'RESPONSIVE_THEME_URI', trailingslashit( esc_url( get_template_directory_uri() ) ) );
define( 'RESPONSIVE_PRO_OLDER_VERSION_CHECK', '2.4.2' );

/**
 *
 * WARNING: Please do not edit this file in any way
 *
 * Load the theme function files
 */
global $responsive_blog_layout_columns;
$responsive_blog_layout_columns = array( 'blog-2-col', 'blog-3-col', 'blog-4-col' );

$responsive_template_directory = get_template_directory();
require $responsive_template_directory . '/core/includes/functions.php';
require $responsive_template_directory . '/core/includes/functions-update.php';
require $responsive_template_directory . '/core/includes/functions-sidebar.php';
require $responsive_template_directory . '/core/includes/functions-install.php';
require $responsive_template_directory . '/core/includes/functions-admin.php';
require $responsive_template_directory . '/core/includes/functions-extras.php';
require $responsive_template_directory . '/core/includes/functions-extensions.php';
require $responsive_template_directory . '/core/includes/theme-options/theme-options.php';
require $responsive_template_directory . '/core/includes/post-custom-meta.php';
require $responsive_template_directory . '/core/includes/hooks.php';
require $responsive_template_directory . '/core/includes/version.php';
require $responsive_template_directory . '/core/includes/customizer/controls/typography/webfonts.php';
require $responsive_template_directory . '/core/includes/customizer/helper.php';
require $responsive_template_directory . '/core/includes/customizer/customizer.php';
require $responsive_template_directory . '/core/includes/customizer/custom-styles.php';
require $responsive_template_directory . '/core/includes/compatibility/woocommerce/class-responsive-woocommerce.php';
require $responsive_template_directory . '/core/includes/compatibility/sensei/class-responsive-sensei.php';
require $responsive_template_directory . '/admin/admin-functions.php';
require $responsive_template_directory . '/core/includes/classes/class-responsive-mobile-menu-markup.php';
require $responsive_template_directory . '/core/gutenberg/gutenberg-support.php';
require $responsive_template_directory . '/core/includes/compatibility/lifterlms/class-responsive-lifterlms.php';
require $responsive_template_directory . '/core/includes/modules/related-posts/class-responsive-related-posts.php';
// Deprecated functions.
require $responsive_template_directory . '/core/includes/functions-deprecated.php';
// Custom page walker.
require $responsive_template_directory . '/core/includes/classes/class-responsive-walker-page.php';

if ( is_admin() ) {
	/**
	 * Admin Menu Settings
	 */
	require_once $responsive_template_directory . '/core/includes/classes/class-responsive-admin-settings.php';
}

/**
 * Run setup functions.
 */
Responsive\setup();
Responsive\Admin\setup();
Responsive\Customizer\setup();
Responsive\Core\setup();
Responsive\Extra\setup();
if ( class_exists( 'WooCommerce' ) ) {
	Responsive\WooCommerce\setup();
}

/**
 * Return value of the supplied responsive free theme option.
 *
 * @param  array   $option  options.
 * @param  boolean $default flag.
 */
function responsive_free_get_option( $option, $default = false ) {
	global $responsive_options;

	// If the option is set then return it's value, otherwise return false.
	if ( isset( $responsive_options[ $option ] ) ) {
		return $responsive_options[ $option ];
	}

	return $default;
}


/**
 * Set the $content_width global variable used by WordPress to set image dimennsions.
 *
 * @return void
 */
function responsive_setup_content_width() {
	global $content_width;

	/**
	 * Content Width
	 */
	if ( ( 'contained' === get_theme_mod( 'responsive_width', 'contained' ) ) ) {
		$container_max_width = esc_html( get_theme_mod( 'responsive_container_width', 1140 ) );

		if ( is_page() && ( class_exists( 'WooCommerce' ) && ( ! is_cart() || ! is_checkout() ) ) ) {
			if ( 'no' !== get_theme_mod( 'responsive_page_sidebar_position', 'right' ) ) {
				$blog_content_width = esc_html( get_theme_mod( 'responsive_page_content_width', 66 ) );

				$content_width = ( $blog_content_width / 100 ) * $container_max_width;
			} else {
				$content_width = $container_max_width;
			}
		} elseif ( is_single() ) {

			if ( 'no' !== get_theme_mod( 'responsive_single_blog_sidebar_position', 'right' ) ) {
				$blog_content_width = esc_html( get_theme_mod( 'responsive_single_blog_content_width', 66 ) );

				$content_width = ( $blog_content_width / 100 ) * $container_max_width;
			} else {
				$content_width = $container_max_width;
			}
		} else {
			if ( 'no' !== get_theme_mod( 'responsive_blog_sidebar_position', 'right' ) ) {
				$blog_content_width = esc_html( get_theme_mod( 'responsive_blog_content_width', Responsive\Core\get_responsive_customizer_defaults( 'blog_content_width' ) ) );

				$content_width = ( $blog_content_width / 100 ) * $container_max_width;
			} else {
				$content_width = $container_max_width;
			}
		}

		if ( class_exists( 'WooCommerce' ) ) {
			if ( is_product() ) {
				if ( 'no' !== get_theme_mod( 'responsive_single_product_sidebar_position', 'no' ) ) {
					$blog_content_width = esc_html( get_theme_mod( 'responsive_single_product_content_width', 100 ) );

					$content_width = ( $blog_content_width / 100 ) * $container_max_width;
				} else {
					$content_width = $container_max_width;
				}
			} elseif ( is_shop() ) {
				if ( 'no' !== get_theme_mod( 'responsive_shop_sidebar_position', 'no' ) ) {
					$blog_content_width = esc_html( get_theme_mod( 'responsive_shop_content_width', Responsive\Core\get_responsive_customizer_defaults( 'shop_content_width' ) ) );

					$content_width = ( $blog_content_width / 100 ) * $container_max_width;
				} else {
					$content_width = $container_max_width;
				}
			} elseif ( is_cart() ) {
				if ( 'no' !== get_theme_mod( 'responsive_shop_sidebar_position', 'no' ) ) {
					$blog_content_width = esc_html( get_theme_mod( 'responsive_cart_content_width', 70 ) );

					$content_width = ( $blog_content_width / 100 ) * $container_max_width;
				} else {
					$content_width = $container_max_width;
				}
			} elseif ( is_checkout() ) {
				if ( 'no' !== get_theme_mod( 'responsive_shop_sidebar_position', 'no' ) ) {
					$blog_content_width = esc_html( get_theme_mod( 'responsive_checkout_content_width', 70 ) );

					$content_width = ( $blog_content_width / 100 ) * $container_max_width;
				} else {
					$content_width = $container_max_width;
				}
			}
		}
	}
}
add_action( 'wp', 'responsive_setup_content_width' );

/**
 * Responsive_free_setup
 */
function responsive_free_setup() {
	add_theme_support( 'title-tag' );
	add_theme_support( 'sensei' );

	// Adding Gutenberg support.
	add_theme_support( 'align-wide' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'responsive-embeds' );
	add_theme_support( 'editor-styles' );
	add_editor_style( 'core/css/gutenberg-editor.css' );
	// Gutenberg editor color palette.
	add_theme_support( 'editor-color-palette', responsive_gutenberg_color_palette() );
	$small_font_sizes  = get_theme_mod( 'meta_typography' );
	$normal_sizes      = get_theme_mod( 'body_typography' );
	$larger_font_sizes = get_theme_mod( 'heading_h1_typography' );
	$large_font_sizes  = get_theme_mod( 'heading_h2_typography' );
	if ( isset( $small_font_sizes['font-size'] ) ) {
		$small_font_sizes_default_value = ( $small_font_sizes && isset( $small_font_sizes['font-size'] ) ) ? str_replace( 'px', '', $small_font_sizes['font-size'] ) : '12';
	} else {
		$small_font_sizes_default_value = 13;
	}
	if ( isset( $normal_sizes['font-size'] ) ) {
		$normal_sizes_default_value = ( $normal_sizes && isset( $normal_sizes['font-size'] ) ) ? str_replace( 'px', '', $normal_sizes['font-size'] ) : '16';
	} else {
		$normal_sizes_default_value = 16;
	}
	if ( isset( $larger_font_sizes['font-size'] ) ) {
		if ( false === strpos( $larger_font_sizes['font-size'], 'px' ) ) {
			$larger_font_sizes_default_value = ( $larger_font_sizes && isset( $larger_font_sizes['font-size'] ) ) ? str_replace( array( 'em', 'rem' ), '', $larger_font_sizes['font-size'] ) : '2.625';
			$larger_font_sizes_default_value = $normal_sizes_default_value * $larger_font_sizes_default_value;
		} else {
			$larger_font_sizes_default_value = str_replace( 'px', '', $larger_font_sizes['font-size'] );
		}
	} else {
		$larger_font_sizes_default_value = 33;
	}

	if ( isset( $large_font_sizes['font-size'] ) ) {
		if ( false === strpos( $large_font_sizes['font-size'], 'px' ) ) {
			$large_font_sizes_default_value = ( $large_font_sizes && isset( $large_font_sizes['font-size'] ) ) ? str_replace( array( 'em', 'rem' ), '', $large_font_sizes['font-size'] ) : '2.250';
			$large_font_sizes_default_value = $normal_sizes_default_value * $large_font_sizes_default_value;
		} else {
			$large_font_sizes_default_value = str_replace( 'px', '', $large_font_sizes['font-size'] );
		}
	} else {
		$large_font_sizes_default_value = 26;
	}
	add_theme_support(
		'editor-font-sizes',
		array(
			array(
				'name'      => _x( 'Small', 'Name of the small font size in the block editor', 'responsive' ),
				'shortName' => _x( 'S', 'Short name of the small font size in the block editor.', 'responsive' ),
				'size'      => $small_font_sizes_default_value,
				'slug'      => 'small',
			),
			array(
				'name'      => _x( 'Regular', 'Name of the regular font size in the block editor', 'responsive' ),
				'shortName' => _x( 'M', 'Short name of the regular font size in the block editor.', 'responsive' ),
				'size'      => $normal_sizes_default_value,
				'slug'      => 'normal',
			),
			array(
				'name'      => _x( 'Large', 'Name of the large font size in the block editor', 'responsive' ),
				'shortName' => _x( 'L', 'Short name of the large font size in the block editor.', 'responsive' ),
				'size'      => $large_font_sizes_default_value,
				'slug'      => 'large',
			),
			array(
				'name'      => _x( 'Larger', 'Name of the larger font size in the block editor', 'responsive' ),
				'shortName' => _x( 'XL', 'Short name of the larger font size in the block editor.', 'responsive' ),
				'size'      => $larger_font_sizes_default_value,
				'slug'      => 'larger',
			),
		)
	);
}
add_action( 'after_setup_theme', 'responsive_free_setup' );

$responsive_options = Responsive\Core\responsive_get_options();

/**
 * Edit Customize Register
 *
 * @param array $wp_customize WP Customize.
 */
function responsive_edit_customize_register( $wp_customize ) {
	$wp_customize->selective_refresh->add_partial(
		'blogname',
		array(
			'selector' => '.site-name a',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'blogdescription',
		array(
			'selector' => '.site-description',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[home_headline]',
		array(
			'selector' => '.featured-title',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[home_subheadline]',
		array(
			'selector' => '.featured-subtitle',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[cta_text]',
		array(
			'selector' => '.call-to-action',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[banner_image]',
		array(
			'selector' => '#featured',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[about_title]',
		array(
			'selector' => '#about_div .section_title',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[about_text]',
		array(
			'selector' => '.about_text',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[about_cta_text]',
		array(
			'selector' => '.about-cta-button',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[feature_title]',
		array(
			'selector' => '#feature_div .section_title',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[testimonial_title]',
		array(
			'selector' => '#testimonial_div .section_title',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[team_title]',
		array(
			'selector' => '#team_div .section_title',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'nav_menu_locations[top]',
		array(
			'selector' => '.main-nav',
		)
	);

	$wp_customize->selective_refresh->add_partial(
		'sidebars_widgets[home-widget-1]',
		array(
			'selector' => '#home_widget_1',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'sidebars_widgets[home-widget-2]',
		array(
			'selector' => '#home_widget_2',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'sidebars_widgets[home-widget-3]',
		array(
			'selector' => '#home_widget_3',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[featured_content]',
		array(
			'selector' => '#featured-image',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[home_content_area]',
		array(
			'selector' => '#featured-content p',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[copyright_textbox]',
		array(
			'selector' => '.copyright',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[contact_title]',
		array(
			'selector' => '.contact_title',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[contact_subtitle]',
		array(
			'selector' => '.contact_subtitle',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[contact_add]',
		array(
			'selector' => '.contact_add',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[contact_email]',
		array(
			'selector' => '.contact_email',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[contact_ph]',
		array(
			'selector' => '.contact_ph',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[contact_content]',
		array(
			'selector' => '.contact_right',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'header_image',
		array(
			'selector' => '#site-branding',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_date_box_toggle',
		array(
			'selector' => '.responsive-date-box',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_hamburger_menu_label_text',
		array(
			'selector'            => '.hamburger-menu-label',
			'container_inclusive' => false,
			'render_callback'     => function() {
				printf( esc_html( responsive_hamburger_menu_label() ) );
			},
			'fallback_refresh'    => true,
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_hamburger_off_canvas_btn_label_text',
		array(
			'selector'            => '.off-canvas-filter-text',
			'container_inclusive' => false,
			'render_callback'     => function() {
				printf( esc_html( responsive_hamburger_off_canvas_btn_label_text_label() ) );
			},
			'fallback_refresh'    => true,
		)
	);

}
add_action( 'customize_register', 'responsive_edit_customize_register' );
add_theme_support( 'customize-selective-refresh-widgets' );

/**
 * Custom Category Widget
 *
 * @param array $arg Arguments.
 * @return mixed
 */
function responsive_custom_category_widget( $arg ) {
	$cat = get_theme_mod( 'exclude_post_cat' );

	if ( $cat ) {
		$cat            = array_diff( array_unique( $cat ), array( '' ) );
		$arg['exclude'] = $cat;
	}
	return $arg;
}
add_filter( 'widget_categories_args', 'responsive_custom_category_widget' );
add_filter( 'widget_categories_dropdown_args', 'responsive_custom_category_widget' );

/**
 * Exclude post category recent post widget
 *
 * @param array $array Array.
 * @return mixed
 */
function responsive_exclude_post_cat_recentpost_widget( $array ) {
	$s   = '';
	$i   = 1;
	$cat = get_theme_mod( 'exclude_post_cat' );

	if ( $cat ) {
		$cat = array_diff( array_unique( $cat ), array( '' ) );
		foreach ( $cat as $c ) {
			$i++;
			$s .= '-' . $c;
			if ( count( $cat ) >= $i ) {
				$s .= ', ';
			}
		}
	}

	$array['cat'] = array( $s );

	return $array;
}
add_filter( 'widget_posts_args', 'responsive_exclude_post_cat_recentpost_widget' );

if ( ! function_exists( 'responsive_page_featured_image' ) ) :

	/**
	 * Featured image
	 */
	function responsive_page_featured_image() {
		// check if the page has a Post Thumbnail assigned to it.
		$responsive_options = Responsive\Core\responsive_get_options();
		if ( has_post_thumbnail() ) {
			?>
						<div class="featured-image">
						<?php /* translators: 1 : Permalink, 2 : Title */ ?>
							<a href="<?php the_permalink(); ?>" aria-label="<?php printf( esc_attr__( 'Permalink to %s', 'responsive' ), the_title_attribute( 'echo=0' ) ); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'responsive' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark" <?php responsive_schema_markup( 'url' ); ?>>
								<?php	the_post_thumbnail(); ?>
							</a>
						</div>
					<?php
		}
	}

endif;

/**
 * Exclude post with Category from blog and archive page.
 */
if ( ! function_exists( 'responsive_exclude_post_cat' ) ) :
	/**
	 * Exclude post with Category from blog and archive page.
	 *
	 * @param  object $query Query.
	 */
	function responsive_exclude_post_cat( $query ) {
		$responsive_options = Responsive\Core\responsive_get_options();
		$cat                = get_theme_mod( 'exclude_post_cat' );

		if ( $cat && ! is_admin() && $query->is_main_query() ) {
			if ( ! array( $cat ) ) {
				$cat = array( $cat );
			}
			$cat = array_diff( array_unique( $cat ), array( '' ) );
			if ( $query->is_home() || $query->is_archive() ) {
				$query->set( 'category__not_in', $cat );
			}
		}
	}
endif;
add_action( 'pre_get_posts', 'responsive_exclude_post_cat', 10 );

/**
 * Enqueue customizer styling
 */
function responsive_controls_style() {
	$suffix = '';
	if ( is_rtl() ) {
		$suffix = '-rtl';
	}
	wp_enqueue_style( 'responsive-blocks', get_template_directory_uri() . '/core/css/customizer' . $suffix . '.css', RESPONSIVE_THEME_VERSION, 'all' );
}

add_action( 'customize_controls_print_styles', 'responsive_controls_style' );

/**
 * Add rating links to the admin dashboard
 *
 * @param string $footer_text The existing footer text.
 *
 * @return      string
 * @since        2.0.6
 * @global        string $typenow
 */
function responsive_admin_rate_us( $footer_text ) {
	$page        = isset( $_GET['page'] ) ? $_GET['page'] : ''; //phpcs:ignore
	$show_footer = array( 'responsive-options' );

	if ( in_array( $page, $show_footer, true ) ) {
		$rate_text = sprintf(
			/* translators: %s Link to 5 star rating */
			__( 'If you like <strong>Responsive Theme</strong> please leave us a %s rating. It takes a minute and helps a lot. Thanks in advance!', 'responsive' ),
			'<a href="https://wordpress.org/support/theme/responsive/reviews/#new-post" target="_blank" class="responsive-rating-link" style="text-decoration:none;" data-rated="' . esc_attr__( 'Thanks :)', 'responsive' ) . '">&#9733;&#9733;&#9733;&#9733;&#9733;</a>'
		);

		return $rate_text;
	} else {
		return $footer_text;
	}
}

add_filter( 'admin_footer_text', 'responsive_admin_rate_us' );


if ( ! get_option( 'responsive_version_410' ) ) {


	/**
	 * Check the responsive version is above 4.1.0.
	 * Change the value layout if it is fullwidth_without_box.
	 */
	function responsive_check_previous_version() {
		$theme_data = wp_get_theme();

		$is_child = is_child_theme( $theme_data );

		if ( $is_child ) {
			$new_version = $theme_data->parent()->get( 'Version' );
		} else {
			$new_version = $theme_data->get( 'Version' );
		}

		global $responsive_options;
		$responsive_options = Responsive\Core\responsive_get_options();
		$header_layout      = get_theme_mod( 'header_layout_options' );
		$menu_position      = get_theme_mod( 'menu_position' );

		// Check if we had a response and compare the current version on wp.org to version 2. If it is version 2 or greater display a message.
		if ( $new_version && version_compare( $new_version, '4.1.0', '>=' ) ) {

			if ( ! $responsive_options['home_headline'] ) {
				$responsive_options['home_headline'] = __( 'HAPPINESS', 'responsive' );
			}
			if ( ! $responsive_options['home_subheadline'] ) {
				$responsive_options['home_subheadline'] = __( 'IS A WARM CUP', 'responsive' );
			}
			if ( ! $responsive_options['home_content_area'] ) {
				$responsive_options['home_content_area'] = __( 'Your title, subtitle and this very content is editable from Theme Option. Call to Action button and its destination link as well. Image on your right can be an image or even YouTube video if you like.', 'responsive' );
			}
			if ( ! $responsive_options['cta_text'] ) {
				$responsive_options['cta_text'] = __( 'Call to Action', 'responsive' );
			}
			if ( ! $responsive_options['cta_url'] ) {
				$responsive_options['cta_url'] = __( '#', 'responsive' );
			}

			( ! get_theme_mod( 'responsive_hide_tagline' ) && get_theme_mod( 'res_hide_tagline' ) ) ? set_theme_mod( 'responsive_hide_tagline', get_theme_mod( 'res_hide_tagline', 1 ) ) : '';
			( ! get_theme_mod( 'responsive_hide_title' ) && get_theme_mod( 'res_hide_site_title' ) ) ? set_theme_mod( 'responsive_hide_title', get_theme_mod( 'res_hide_site_title', 0 ) ) : '';

			( ! get_theme_mod( 'responsive_button_color' ) && get_theme_mod( 'button-color' ) ) ? set_theme_mod( 'responsive_button_color', get_theme_mod( 'button-color', '#0066CC' ) ) : '';
			( ! get_theme_mod( 'responsive_button_hover_color' ) && get_theme_mod( 'button-hover-color' ) ) ? set_theme_mod( 'responsive_button_hover_color', get_theme_mod( 'button-hover-color', '#10659C' ) ) : '';
			( ! get_theme_mod( 'responsive_button_text_color' ) && get_theme_mod( 'button-text-color' ) ) ? set_theme_mod( 'responsive_button_text_color', get_theme_mod( 'button-text-color', '#FFFFFF' ) ) : '';
			( ! get_theme_mod( 'responsive_button_hover_text_color' ) && get_theme_mod( 'button-hover-text-color' ) ) ? set_theme_mod( 'responsive_button_hover_text_color', get_theme_mod( 'button-hover-text-color', '#FFFFFF' ) ) : '';

			( ! get_theme_mod( 'responsive_inputs_background_color' ) && get_theme_mod( 'input-background-color' ) ) ? set_theme_mod( 'responsive_inputs_background_color', get_theme_mod( 'input-background-color', '#FFFFFF' ) ) : '';
			( ! get_theme_mod( 'responsive_inputs_text_color' ) && get_theme_mod( 'input-text-color' ) ) ? set_theme_mod( 'responsive_inputs_text_color', get_theme_mod( 'input-text-color', '#333333' ) ) : '';
			( ! get_theme_mod( 'responsive_inputs_border_color' ) && get_theme_mod( 'input-border-color' ) ) ? set_theme_mod( 'responsive_inputs_border_color', get_theme_mod( 'input-border-color', '#cccccc' ) ) : '';

			( ! get_theme_mod( 'responsive_label_color' ) && get_theme_mod( 'label-color' ) ) ? set_theme_mod( 'responsive_label_color', get_theme_mod( 'label-color', '#333333' ) ) : '';

			( ! get_theme_mod( 'responsive_header_menu_background_color' ) && get_theme_mod( 'responsive_menu_background_colorpicker' ) ) ? set_theme_mod( 'responsive_header_menu_background_color', get_theme_mod( 'responsive_menu_background_colorpicker', '#ffffff' ) ) : '';
			( ! get_theme_mod( 'responsive_header_active_menu_background_color' ) && get_theme_mod( 'responsive_menu_active_colorpicker' ) ) ? set_theme_mod( 'responsive_header_active_menu_background_color', get_theme_mod( 'responsive_menu_active_colorpicker', '#ffffff' ) ) : '';
			if ( '#ffffff' !== get_theme_mod( 'responsive_header_menu_background_color', '#ffffff' ) ) {
				! get_theme_mod( 'responsive_header_menu_link_color' ) ? set_theme_mod( 'responsive_header_menu_link_color', get_theme_mod( 'responsive_menu_text_colorpicker', '#ffffff' ) ) : '';
				! get_theme_mod( 'responsive_header_menu_toggle_color' ) ? set_theme_mod( 'responsive_header_menu_toggle_color', get_theme_mod( 'responsive_menu_text_colorpicker', '#ffffff' ) ) : '';
			}
			if ( '#ffffff' !== get_theme_mod( 'responsive_header_active_menu_background_color', '#ffffff' ) ) {
				! get_theme_mod( 'responsive_header_menu_link_hover_color' ) ? set_theme_mod( 'responsive_header_menu_link_hover_color', get_theme_mod( 'responsive_menu_text_hover_colorpicker', '#ffffff' ) ) : '';
			}
			( ! get_theme_mod( 'responsive_header_menu_toggle_color' ) && get_theme_mod( 'responsive_menu_text_colorpicker' ) ) ? set_theme_mod( 'responsive_header_menu_toggle_color', get_theme_mod( 'responsive_menu_text_colorpicker', '#333333' ) ) : '';
			( ! get_theme_mod( 'responsive_header_menu_link_color' ) && get_theme_mod( 'responsive_menu_text_colorpicker' ) ) ? set_theme_mod( 'responsive_header_menu_link_color', get_theme_mod( 'responsive_menu_text_colorpicker', '#333333' ) ) : '';
			( ! get_theme_mod( 'responsive_header_menu_border_color' ) && get_theme_mod( 'responsive_menu_border_color' ) ) ? set_theme_mod( 'responsive_header_menu_border_color', get_theme_mod( 'responsive_menu_border_color', '#eaeaea' ) ) : '';
			( ! get_theme_mod( 'responsive_header_menu_link_hover_color' ) && get_theme_mod( 'responsive_menu_text_hover_colorpicker' ) ) ? set_theme_mod( 'responsive_header_menu_link_hover_color', get_theme_mod( 'responsive_menu_text_hover_colorpicker', '#10659C' ) ) : '';
			( ! get_theme_mod( 'responsive_header_background_color' ) && get_theme_mod( 'responsive_fullwidth_header_color' ) ) ? set_theme_mod( 'responsive_header_background_color', get_theme_mod( 'responsive_fullwidth_header_color', '#ffffff' ) ) : '';
			( ! get_theme_mod( 'responsive_header_border_color' ) && get_theme_mod( 'responsive_header_background_color' ) ) ? set_theme_mod( 'responsive_header_border_color', get_theme_mod( 'responsive_header_background_color', '#eaeaea' ) ) : '';
			( ! get_theme_mod( 'responsive_header_site_title_color' ) && get_theme_mod( 'responsive_fullwidth_sitetitle_color' ) ) ? set_theme_mod( 'responsive_header_site_title_color', get_theme_mod( 'responsive_fullwidth_sitetitle_color', '#333333' ) ) : '';
			( ! get_theme_mod( 'responsive_header_text_color' ) && get_theme_mod( 'responsive_site_description_color' ) ) ? set_theme_mod( 'responsive_header_text_color', get_theme_mod( 'responsive_site_description_color', '#999999' ) ) : '';

			( ! get_theme_mod( 'responsive_header_sub_menu_background_color' ) && get_theme_mod( 'responsive_header_menu_background_color' ) ) ? set_theme_mod( 'responsive_header_sub_menu_background_color', get_theme_mod( 'responsive_header_menu_background_color', '#ffffff' ) ) : '';
			( ! get_theme_mod( 'responsive_header_sub_menu_link_color' ) && get_theme_mod( 'responsive_header_menu_link_color' ) ) ? set_theme_mod( 'responsive_header_sub_menu_link_color', get_theme_mod( 'responsive_header_menu_link_color', '#333333' ) ) : '';
			( ! get_theme_mod( 'responsive_header_sub_menu_link_hover_color' ) && get_theme_mod( 'responsive_header_menu_link_hover_color' ) ) ? set_theme_mod( 'responsive_header_sub_menu_link_hover_color', get_theme_mod( 'responsive_header_menu_link_hover_color', '#10659C' ) ) : '';

			( ! get_theme_mod( 'responsive_box_background_color' ) && get_theme_mod( 'responsive_container_background_color' ) ) ? set_theme_mod( 'responsive_box_background_color', get_theme_mod( 'responsive_container_background_color', '#ffffff' ) ) : '';
			if ( '#ffffff' !== get_theme_mod( 'responsive_box_background_color', '#ffffff' ) ) {
				! get_theme_mod( 'background_color' ) ? set_theme_mod( 'background_color', 'ffffff' ) : '';
			}

			( ! get_theme_mod( 'responsive_link_color' ) && get_theme_mod( 'link-color' ) ) ? set_theme_mod( 'responsive_link_color', get_theme_mod( 'link-color', '#0066CC' ) ) : '';
			( ! get_theme_mod( 'responsive_link_hover_color' ) && get_theme_mod( 'link-hover-color' ) ) ? set_theme_mod( 'responsive_link_hover_color', get_theme_mod( 'link-hover-color', '#10659C' ) ) : '';
			( ! get_theme_mod( 'responsive_blog_entry_read_more_type' ) && get_theme_mod( 'responsive_display_read_more_as_button' ) ) ? set_theme_mod( 'responsive_blog_entry_read_more_type', 'button' ) : '';
			( ! get_theme_mod( 'responsive_blog_entry_title_alignment' ) && get_theme_mod( 'responsive_blog_title_alignment_options' ) ) ? set_theme_mod( 'responsive_blog_entry_title_alignment', get_theme_mod( 'responsive_blog_title_alignment_options', 'left' ) ) : '';
			( ! get_theme_mod( 'responsive_blog_entry_meta_alignment' ) && get_theme_mod( 'responsive_blog_entries_meta_position' ) ) ? set_theme_mod( 'responsive_blog_entry_meta_alignment', get_theme_mod( 'responsive_blog_entries_meta_position', 'left' ) ) : '';
			( ! get_theme_mod( 'responsive_single_blog_title_alignment' ) && get_theme_mod( 'responsive_single_title_alignment_options' ) ) ? set_theme_mod( 'responsive_single_blog_title_alignment', get_theme_mod( 'responsive_single_title_alignment_options', 'left' ) ) : '';
			( ! get_theme_mod( 'responsive_single_blog_meta_alignment' ) && get_theme_mod( 'responsive_single_post_meta_position' ) ) ? set_theme_mod( 'responsive_single_blog_meta_alignment', get_theme_mod( 'responsive_single_post_meta_position', 'left' ) ) : '';

			if ( '#ffffff' === get_theme_mod( 'responsive_footer_background_color' ) ) {
				! get_theme_mod( 'responsive_footer_text_color' ) ? set_theme_mod( 'responsive_footer_text_color', '#333333' ) : '';
				! get_theme_mod( 'responsive_footer_links_color' ) ? set_theme_mod( 'responsive_footer_links_color', '#999999' ) : '';
				! get_theme_mod( 'responsive_footer_links_hover_color' ) ? set_theme_mod( 'responsive_footer_links_hover_color', '#333333' ) : '';
			}

			$header_layout = array( 'above_header', 'below_header' );
			if ( in_array( get_theme_mod( 'menu_position' ), $header_layout, true ) ) {
				! get_theme_mod( 'responsive_header_layout' ) ? set_theme_mod( 'responsive_header_layout', 'vertical' ) : '';

				if ( 'above_header' === get_theme_mod( 'menu_position' ) ) {
					! get_theme_mod( 'responsive_header_elements' ) ? set_theme_mod( 'responsive_header_elements', array( 'main-navigation', 'site-branding' ) ) : '';
				}
			}

			if ( 'in_header' === get_theme_mod( 'menu_position' ) && 'header-logo-right' === get_theme_mod( 'header_layout_options' ) ) {
				! get_theme_mod( 'responsive_header_elements' ) ? set_theme_mod( 'responsive_header_elements', array( 'main-navigation', 'site-branding' ) ) : '';
			}

			! get_theme_mod( 'responsive_header_alignment' ) && get_theme_mod( 'header_layout_options' ) ? set_theme_mod( 'responsive_header_alignment', str_replace( 'header-logo-', '', get_theme_mod( 'header_layout_options' ) ) ) : '';
			! get_theme_mod( 'responsive_container_width' ) ? set_theme_mod( 'responsive_container_width', get_theme_mod( 'responsive_main_container_width', 1140 ) ) : '';

			$responsive_options_blog = array( 'full-width-page', 'blog-2-col', 'blog-3-col', 'blog-4-col' );

			if ( in_array( $responsive_options['blog_posts_index_layout_default'], $responsive_options_blog, true ) ) {
				! get_theme_mod( 'responsive_blog_sidebar_position' ) ? set_theme_mod( 'responsive_blog_sidebar_position', 'no' ) : '';
				! get_theme_mod( 'responsive_blog_content_width' ) ? set_theme_mod( 'responsive_blog_content_width', 100 ) : '';
				for ( $i = 0; $i < 4; $i++ ) {
					if ( 'blog-' . $i . '-col' === $responsive_options['blog_posts_index_layout_default'] ) {
						! get_theme_mod( 'responsive_blog_entry_columns' ) ? set_theme_mod( 'responsive_blog_entry_columns', $i ) : '';
						! get_theme_mod( 'responsive_blog_entry_display_masonry' ) ? set_theme_mod( 'responsive_blog_entry_display_masonry', get_theme_mod( 'responsive_display_masonry' ) ) : '';
					}
				}
			}

			if ( 'sidebar-content-page' === $responsive_options['blog_posts_index_layout_default'] ) {
				! get_theme_mod( 'responsive_blog_sidebar_position' ) ? set_theme_mod( 'responsive_blog_sidebar_position', 'left' ) : '';
			}

			if ( get_theme_mod( 'responsive_display_thumbnail_without_padding' ) ) {
				! get_theme_mod( 'responsive_blog_entry_featured_image_style' ) ? set_theme_mod( 'responsive_blog_entry_featured_image_style', 'stretched' ) : '';
			}

			if ( 'sidebar-content-page' === $responsive_options['single_post_layout_default'] ) {
				! get_theme_mod( 'responsive_single_blog_sidebar_position' ) ? set_theme_mod( 'responsive_single_blog_sidebar_position', 'left' ) : '';
			}

			if ( 'full-width-page' === $responsive_options['single_post_layout_default'] ) {
				! get_theme_mod( 'responsive_single_blog_sidebar_position' ) ? set_theme_mod( 'responsive_single_blog_sidebar_position', 'no' ) : '';
				! get_theme_mod( 'responsive_single_blog_content_width' ) ? set_theme_mod( 'responsive_single_blog_content_width', 100 ) : '';
			}

			if ( 'sidebar-content-page' === $responsive_options['static_page_layout_default'] ) {
				! get_theme_mod( 'responsive_single_blog_sidebar_position' ) ? set_theme_mod( 'responsive_single_blog_sidebar_position', 'left' ) : '';
			}

			if ( 'full-width-page' === $responsive_options['static_page_layout_default'] ) {
				! get_theme_mod( 'responsive_page_sidebar_position' ) ? set_theme_mod( 'responsive_page_sidebar_position', 'no' ) : '';
				! get_theme_mod( 'responsive_page_content_width' ) ? set_theme_mod( 'responsive_page_content_width', 100 ) : '';
			}

			if ( 'fullwidth-stretched' === $responsive_options['site_layout_option'] ) {
				if ( '#ffffff' === get_theme_mod( 'responsive_box_background_color' ) ) {
					'ffffff' !== get_theme_mod( 'background_color' ) ? set_theme_mod( 'background_color', 'ffffff' ) : '';
				}
			}

			if ( 'full' === get_theme_mod( 'header_width' ) ) {
				( ! get_theme_mod( 'responsive_header_menu_full_width' ) && 0 !== get_theme_mod( 'responsive_header_menu_full_width' ) ) ? set_theme_mod( 'responsive_header_menu_full_width', 1 ) : '';
			}

			$body_typography = get_theme_mod( 'body_typography' );
			if ( $body_typography && array_key_exists( 'color', $body_typography ) ) {
				! get_theme_mod( 'responsive_body_text_color' ) ? set_theme_mod( 'responsive_body_text_color', $body_typography['color'] ) : '';
			}

			$menu_typography        = get_theme_mod( 'menu_typography' );
			$header_menu_typography = get_theme_mod( 'header_menu_typography' );

			if ( $menu_typography ) {
				if ( ! $header_menu_typography ) {
					set_theme_mod( 'header_menu_typography', $menu_typography );
				}
			}

			$post_meta_typography = get_theme_mod( 'post_meta_typography' );
			$meta_typography      = get_theme_mod( 'meta_typography' );

			if ( $post_meta_typography ) {
				if ( ! $meta_typography ) {
					set_theme_mod( 'meta_typography', $post_meta_typography );
				}
			}

			$meta_typography = get_theme_mod( 'post_meta_typography' );
			if ( $meta_typography && array_key_exists( 'color', $meta_typography ) ) {
				! get_theme_mod( 'responsive_meta_text_color' ) ? set_theme_mod( 'responsive_meta_text_color', $meta_typography['color'] ) : '';
			}

			for ( $i = 1; $i < 7; $i++ ) {
				$heading_h = get_theme_mod( 'heading_h' . $i . '_typography' );
				$heading   = get_theme_mod( 'headings_typography' );
				if ( $heading ) {
					if ( ! get_theme_mod( 'heading_h' . $i . '_typography' ) ) {
						set_theme_mod( 'heading_h' . $i . '_typography', $heading );
					} else {
						foreach ( $heading as $key => $value ) {
							if ( 'color' !== $key && ( ! array_key_exists( $key, get_theme_mod( 'heading_h' . $i . '_typography' ) ) ) ) {
								$temp      = array( $key => $value );
								$heading_h = $temp + get_theme_mod( 'heading_h' . $i . '_typography' );
								set_theme_mod( 'heading_h' . $i . '_typography', $heading_h );
							}
						}
					}
				}

				if ( $heading_h && array_key_exists( 'color', $heading_h ) ) {
					! get_theme_mod( "responsive_h{$i}_text_color" ) ? set_theme_mod( "responsive_h{$i}_text_color", $heading_h['color'] ) : '';
				}
			}

			if ( class_exists( 'woocommerce' ) ) {
				( ! get_theme_mod( 'responsive_shop_product_rating_color' ) && get_theme_mod( 'responsive_product_rating_color' ) ) ? set_theme_mod( 'responsive_shop_product_rating_color', get_theme_mod( 'responsive_product_rating_color', '#0066CC' ) ) : '';

				( ! get_theme_mod( 'responsive_add_to_cart_button_color' ) && get_theme_mod( 'responsive_button_color' ) ) ? set_theme_mod( 'responsive_add_to_cart_button_color', get_theme_mod( 'responsive_button_color', '#0066CC' ) ) : '';
				( ! get_theme_mod( 'responsive_add_to_cart_button_text_color' ) && get_theme_mod( 'responsive_button_text_color' ) ) ? set_theme_mod( 'responsive_add_to_cart_button_text_color', get_theme_mod( 'responsive_button_text_color', '#ffffff' ) ) : '';
				( ! get_theme_mod( 'responsive_add_to_cart_button_hover_color' ) && get_theme_mod( 'responsive_button_hover_color' ) ) ? set_theme_mod( 'responsive_add_to_cart_button_hover_color', get_theme_mod( 'responsive_button_hover_color', '#10659C' ) ) : '';
				( ! get_theme_mod( 'responsive_add_to_cart_button_hover_text_color' ) && get_theme_mod( 'responsive_button_hover_text_color' ) ) ? set_theme_mod( 'responsive_add_to_cart_button_hover_text_color', get_theme_mod( 'responsive_button_hover_text_color', '#ffffff' ) ) : '';

				( ! get_theme_mod( 'responsive_cart_buttons_color' ) && get_theme_mod( 'responsive_button_color' ) ) ? set_theme_mod( 'responsive_cart_buttons_color', get_theme_mod( 'responsive_button_color', '#0066CC' ) ) : '';
				( ! get_theme_mod( 'responsive_cart_buttons_text_color' ) && get_theme_mod( 'responsive_button_text_color' ) ) ? set_theme_mod( 'responsive_cart_buttons_text_color', get_theme_mod( 'responsive_button_text_color', '#ffffff' ) ) : '';
				( ! get_theme_mod( 'responsive_cart_buttons_hover_color' ) && get_theme_mod( 'responsive_button_hover_color' ) ) ? set_theme_mod( 'responsive_cart_buttons_hover_color', get_theme_mod( 'responsive_button_hover_color', '#10659C' ) ) : '';
				( ! get_theme_mod( 'responsive_cart_buttons_hover_text_color' ) && get_theme_mod( 'responsive_button_hover_text_color' ) ) ? set_theme_mod( 'responsive_cart_buttons_hover_text_color', get_theme_mod( 'responsive_button_hover_text_color', '#ffffff' ) ) : '';

				( ! get_theme_mod( 'responsive_cart_checkout_button_color' ) && get_theme_mod( 'responsive_button_color' ) ) ? set_theme_mod( 'responsive_cart_checkout_button_color', get_theme_mod( 'responsive_button_color', '#0066CC' ) ) : '';
				( ! get_theme_mod( 'responsive_cart_checkout_button_text_color' ) && get_theme_mod( 'responsive_button_text_color' ) ) ? set_theme_mod( 'responsive_cart_checkout_button_text_color', get_theme_mod( 'responsive_button_text_color', '#ffffff' ) ) : '';
				( ! get_theme_mod( 'responsive_cart_checkout_button_hover_color' ) && get_theme_mod( 'responsive_button_hover_color' ) ) ? set_theme_mod( 'responsive_cart_checkout_button_hover_color', get_theme_mod( 'responsive_button_hover_color', '#10659C' ) ) : '';
				( ! get_theme_mod( 'responsive_cart_checkout_button_hover_text_color' ) && get_theme_mod( 'responsive_button_hover_text_color' ) ) ? set_theme_mod( 'responsive_cart_checkout_button_hover_text_color', get_theme_mod( 'responsive_button_hover_text_color', '#ffffff' ) ) : '';
				( ! get_theme_mod( 'responsive_breadcrumb_color' ) && get_theme_mod( 'responsive_product_breadcrumb_color' ) ) ? set_theme_mod( 'responsive_breadcrumb_color', get_theme_mod( 'responsive_product_breadcrumb_color', '#0066CC' ) ) : '';

			}
		}
		update_option( 'responsive_version_410', 1 );
	}

	add_action( 'admin_init', 'responsive_check_previous_version', 5 );
	add_action( 'customize_preview_init', 'responsive_check_previous_version' );
	add_action( 'wp', 'responsive_check_previous_version', 5 );
}
/**
 * Add iFrame to allowed wp_kses_post tags
 *
 * @param array  $tags Allowed tags, attributes, and/or entities.
 * @param string $context Context to judge allowed tags by. Allowed values are 'post'.
 *
 * @return array
 */
function responsive_wpkses_post_tags( $tags, $context ) {
	if ( 'post' === $context ) {
		$tags['iframe'] = array(
			'src'             => true,
			'height'          => true,
			'width'           => true,
			'frameborder'     => true,
			'allowfullscreen' => true,
		);
	}
	return $tags;
}
add_filter( 'wp_kses_allowed_html', 'responsive_wpkses_post_tags', 10, 2 );

/**
 * Register theme locations
 *
 * @param array $elementor_theme_manager  Theme manager.
 */
function responsive_register_elementor_locations( $elementor_theme_manager ) {

	$elementor_theme_manager->register_all_core_location();

}
add_action( 'elementor/theme/register_locations', 'responsive_register_elementor_locations' );

/**
 * [responsive_header_sidebar description]
 *
 * @return void [description]
 */
function responsive_header_sidebar() {
	get_sidebar( 'header' );
}

/**
 * [responsive_header_widget_position description]
 *
 * @return void [description].
 */
function responsive_header_widget_position() {

	if ( ! get_theme_mod( 'responsive_enable_header_widget', 1 ) ) {
		return;
	}

	$responsive_header_widget_position = 'responsive_header_' . get_theme_mod( 'responsive_header_widget_position', 'top' );

	add_action( $responsive_header_widget_position, 'responsive_header_sidebar', 30 );

}
add_action( 'wp_head', 'responsive_header_widget_position' );

if ( ! function_exists( 'wp_body_open' ) ) {
	/**
	 * Fire the wp_body_open action.
	 *
	 * Added for backwards compatibility to support WordPress versions prior to 5.2.0.
	 */
	function wp_body_open() {
		/**
		 * Triggered after the opening <body> tag.
		 */
		do_action( 'wp_body_open' );
	}
}

/**
 * [responsive_nav_menu_link_attributes]
 *
 * @param array $atts Attribute.
 * @param mixed $item Item.
 * @param mixed $args Arguments.
 * @param mixed $depth Depth.
 * @return array $atts.
 */
function responsive_nav_menu_link_attributes( $atts, $item, $args, $depth ) {

	// Add [aria-haspopup] and [aria-expanded] to menu items that have children.
	$item_has_children = in_array( 'menu-item-has-children', $item->classes );
	if ( $item_has_children ) {
		$atts['aria-haspopup'] = 'true';
		$atts['aria-expanded'] = 'false';
	}

	return $atts;
}
add_filter( 'nav_menu_link_attributes', 'responsive_nav_menu_link_attributes', 10, 4 );

/**
 * [responsive_add_sub_toggles_to_main_menu]
 *
 * @param mixed $args Arguments.
 * @param mixed $item Item.
 * @param mixed $depth Depth.
 * @return $args.
 */
function responsive_add_sub_toggles_to_main_menu( $args, $item, $depth ) {
	if ( 'header-menu' === $args->theme_location ) {
		if ( in_array( 'menu-item-has-children', $item->classes, true ) ) {
			$args->after      = '<span class="res-iconify res-iconify-outer">
				<svg width="15" height="8" viewBox="-2.5 -5 75 60" preserveAspectRatio="none"><path d="M0,0 l35,50 l35,-50" fill="none" stroke-linecap="round" stroke-width="10" /></svg>
				</span>';
			$args->link_after = '<span class="res-iconify res-iconify-inner">
				<svg width="15" height="8" viewBox="-2.5 -5 75 60" preserveAspectRatio="none"><path d="M0,0 l35,50 l35,-50" fill="none" stroke-linecap="round" stroke-width="10" /></svg>
				</span>';
		} else {
			$args->after      = '';
			$args->link_after = '';
		}
	}
	return $args;
}

add_filter( 'nav_menu_item_args', 'responsive_add_sub_toggles_to_main_menu', 10, 3 );

if ( ! function_exists( 'responsive_display_date_box' ) ) {
	/**
	 * Display date box on blog/archive page.
	 *
	 * @param mixed $date_box_toggle Date Box Toggle.
	 * @param mixed $toggle Toggle.
	 */
	function responsive_display_date_box( $date_box_toggle, $toggle ) {
		if ( $date_box_toggle ) {
			$datebox_day   = get_the_date( 'j' );
			$datebox_month = get_the_date( 'M' );
			$datebox_year  = get_the_date( 'Y' );
			if ( $toggle ) {
				$date_box_display_value = 'absolute';
				$date_box_special_class = 'with-thumbnail';
			} else {
				$date_box_display_value = '';
				$date_box_special_class = 'without-thumbnail';
			}
			echo '<div class="datebox-container">';
				echo '<div class="responsive-date-box ' . esc_html( $date_box_special_class ) . '" style="position: ' . esc_html( $date_box_display_value ) . '">';
					echo '<a href="' . esc_url( get_permalink() ) . '" class="date-box-links">';
						echo '<div class="date-box-month">' . esc_html( $datebox_month ) . '</div>';
						echo '<div class="date-box-day">' . esc_html( $datebox_day ) . '</div>';
						echo '<div class="date-box-year">' . esc_html( $datebox_year ) . '</div>';
					echo '</a>';
				echo '</div>';
			echo '</div>';
		} else {
			return;
		}
	}
}

if ( ! function_exists( 'responsive_fallback_menu' ) ) {
	/**
	 * Set a fallback menu that will show a home link.
	 */
	function responsive_fallback_menu() {
		$args    = array(
			'depth'               => 0,
			'sort_column'         => 'menu_order, post_title',
			'menu_class'          => 'menu',
			'include'             => '',
			'exclude'             => '',
			'echo'                => false,
			'show_home'           => true,
			'link_before'         => '',
			'link_after'          => '',
			'show_sub_menu_icons' => true,
			'walker'              => new Responsive_Walker_Page(),
		);
		$pages   = wp_page_menu( $args );
		$prepend = '<div id="header-menu" class="menu">';
		$append  = '</div>';
		$output  = $prepend . $pages . $append;
		echo wp_kses_post( $output );
	}
}

add_action( 'wp_footer', 'prevent_menu_icon_redirection' );

/**
 * Prevent redirection after menu icons are clicked.
 */
function prevent_menu_icon_redirection() {
	echo "<script>
	var iconElement = document.querySelectorAll('.res-iconify-inner');
	iconElement.forEach(function(element) {
		element.addEventListener('click', function(e) {
			e.preventDefault();
			e.stopPropagation();
		});
	});
	</script>";
}
