<?php
/**
 * @package Gym Training Coach
 * @subpackage gym-training-coach
 * @since gym-training-coach 1.0
 * Setup the WordPress core custom header feature.
 * @uses gym_training_coach_header_style()
*/

function gym_training_coach_custom_header_setup() {

	add_theme_support( 'custom-header', apply_filters( 'gym_training_coach_custom_header_args', array(
		'default-text-color'     => 'fff',
		'header-text' 			 =>	false,
		'width'                  => 1400,
		'height'                 => 70,
		'flex-width'         	=> true,
        'flex-height'        	=> true,
		'wp-head-callback'       => 'gym_training_coach_header_style',
	) ) );
}

add_action( 'after_setup_theme', 'gym_training_coach_custom_header_setup' );

if ( ! function_exists( 'gym_training_coach_header_style' ) ) :

add_action( 'wp_enqueue_scripts', 'gym_training_coach_header_style' );
function gym_training_coach_header_style() {
	if ( get_header_image() ) :
	$gym_training_coach_custom_css = "
        .main-header{
			background-image:url('".esc_url(get_header_image())."');
			background-position: center top;
			background-size: cover;
		}";
	   	wp_add_inline_style( 'gym-training-coach-basic-style', $gym_training_coach_custom_css );
	endif;
}
endif;