<?php
/**
 * Gym Training Coach Theme Customizer
 * @package Gym Training Coach
 */

load_template( trailingslashit( get_template_directory() ) . '/inc/logo-sizer.php' );
/**
 * Add postMessage support for site title and description for the Theme Customizer.
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function gym_training_coach_customize_register( $wp_customize ) {

	load_template( trailingslashit( get_template_directory() ) . 'inc/custom-control.php' );
	load_template( trailingslashit( get_template_directory() ) . '/inc/icon-changer.php' );

	$wp_customize->add_setting( 'gym_training_coach_logo_sizer',array(
		'default' => 50,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_logo_sizer',array(
		'label' => esc_html__( 'Logo Sizer','gym-training-coach' ),
		'section' => 'title_tagline',
		'priority'    => 9,
		'input_attrs' => array(
			'min' => 0,
			'max' => 100,
			'step' => 1,
		),
	)));
 	// logo padding
	$wp_customize->add_setting( 'gym_training_coach_logo_padding',array(
		'default' => 20,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_logo_padding',array(
		'label' => esc_html__( 'Logo Padding','gym-training-coach' ),
		'section' => 'title_tagline',
		'priority'    => 9,
		'input_attrs' => array(
			'min' => 0,
			'max' => 100,
			'step' => 1,
		),
	)));

	// logo margin
	$wp_customize->add_setting( 'gym_training_coach_logo_margin',array(
		'default' => '',
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_logo_margin',array(
		'label' => esc_html__( 'Logo Margin','gym-training-coach' ),
		'section' => 'title_tagline',
		'priority'    => 9,
		'input_attrs' => array(
			'min' => 0,
			'max' => 100,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting('gym_training_coach_site_title_enable',array(
		'default' => true,
		'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
	));
	$wp_customize->add_control('gym_training_coach_site_title_enable',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Site Title','gym-training-coach'),
		'section' => 'title_tagline'
	));

 	$wp_customize->add_setting('gym_training_coach_site_title_font_size',array(
		'default'=> 25,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_site_title_font_size',array(
		'label' => esc_html__( 'Site Title Font Size (px)','gym-training-coach' ),
		'section'=> 'title_tagline',
		'input_attrs' => array(
         'step' => 1,
			'min'  => 0,
			'max'  => 50,
      ),
	)));

	// site title color
   $wp_customize->add_setting('gym_training_coach_site_title_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_site_title_color', array(
		'label'    => __('Site Title Color', 'gym-training-coach'),
		'section'  => 'title_tagline',
		'settings' => 'gym_training_coach_site_title_color',
	)));

   $wp_customize->add_setting('gym_training_coach_site_tagline_enable',array(
      'default' => false,
      'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
   ));
   $wp_customize->add_control('gym_training_coach_site_tagline_enable',array(
      'type' => 'checkbox',
      'label' => __('Enable / Disable Site Tagline','gym-training-coach'),
      'section' => 'title_tagline'
   ));

   $wp_customize->add_setting('gym_training_coach_site_tagline_font_size',array(
		'default'=> 13,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_site_tagline_font_size',array(
		'label' => esc_html__( 'Site Tagline Font Size (px)','gym-training-coach' ),
		'section'=> 'title_tagline',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
	)));

	// site tagline color
	$wp_customize->add_setting('gym_training_coach_site_tagline_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_site_tagline_color', array(
		'label'    => __('Site Tagline Color', 'gym-training-coach'),
		'section'  => 'title_tagline',
		'settings' => 'gym_training_coach_site_tagline_color',
	)));

    $wp_customize->add_setting('gym_training_coach_site_logo_inline',array(
       'default' => false,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ));
    $wp_customize->add_control('gym_training_coach_site_logo_inline',array(
       'type' => 'checkbox',
       'label' => __('Site logo inline with site title','gym-training-coach'),
       'section' => 'title_tagline',
    ));

    $wp_customize->add_setting('gym_training_coach_background_skin',array(
        'default' => 'Without Background',
        'sanitize_callback' => 'gym_training_coach_sanitize_choices'
	));
	$wp_customize->add_control('gym_training_coach_background_skin',array(
        'type' => 'radio',
        'label' => __('Background Skin','gym-training-coach'),
        'description' => __('Here you can add the background skin along with the background image.','gym-training-coach'),
        'section' => 'background_image',
        'choices' => array(
            'With Background' => __('With Background Skin','gym-training-coach'),
            'Without Background' => __('Without Background Skin','gym-training-coach'),
        ),
	) );

	//Important Links
	$wp_customize->add_section( 'gym_training_coach_important_links' , array(
    	'title' => esc_html__( 'Important Links', 'gym-training-coach' ),
    	'priority' => 10,
	) );

	$wp_customize->add_setting('gym_training_coach_doc_link',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_training_coach_doc_link',array(
		'type'=> 'hidden',
		'description' => "<a target='_blank' href='". esc_url('https://buywptemplates.com/demo/docs/free-gym-wordpress-theme/') ." '>Documentation</a>",
		'section'=> 'gym_training_coach_important_links'
	));

	$wp_customize->add_setting('gym_training_coach_demo_links',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_training_coach_demo_links',array(
		'type'=> 'hidden',
		'description' => "<a target='_blank' href='". esc_url('https://www.buywptemplates.com/gym-training-coach/') ." '>Demo</a>",
		'section'=> 'gym_training_coach_important_links'
	));

	$wp_customize->add_setting('gym_training_coach_forum_links',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_training_coach_forum_links',array(
		'type'=> 'hidden',
		'description' => "<a target='_blank' href='". esc_url('https://wordpress.org/support/theme/gym-training-coach/') ." '>Support Forum</a>",
		'section'=> 'gym_training_coach_important_links'
	));

	//add home page setting pannel
	$wp_customize->add_panel( 'gym_training_coach_panel_id', array(
	    'priority' => 11,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Theme Settings', 'gym-training-coach' ),
	    'description' => __( 'Description of what this panel does.', 'gym-training-coach' ),
	) );

	$gym_training_coach_font_array = array(
		''                       => 'No Fonts',
		'Abril Fatface'          => 'Abril Fatface',
		'Acme'                   => 'Acme',
		'Anton'                  => 'Anton',
		'Architects Daughter'    => 'Architects Daughter',
		'Arimo'                  => 'Arimo',
		'Arsenal'                => 'Arsenal',
		'Arvo'                   => 'Arvo',
		'Alegreya'               => 'Alegreya',
		'Alfa Slab One'          => 'Alfa Slab One',
		'Averia Serif Libre'     => 'Averia Serif Libre',
		'Bangers'                => 'Bangers',
		'Boogaloo'               => 'Boogaloo',
		'Bad Script'             => 'Bad Script',
		'Bitter'                 => 'Bitter',
		'Bree Serif'             => 'Bree Serif',
		'BenchNine'              => 'BenchNine',
		'Cabin'                  => 'Cabin',
		'Cardo'                  => 'Cardo',
		'Courgette'              => 'Courgette',
		'Cherry Swash'           => 'Cherry Swash',
		'Cormorant Garamond'     => 'Cormorant Garamond',
		'Crimson Text'           => 'Crimson Text',
		'Cuprum'                 => 'Cuprum',
		'Cookie'                 => 'Cookie',
		'Chewy'                  => 'Chewy',
		'Days One'               => 'Days One',
		'Dosis'                  => 'Dosis',
		'Droid Sans'             => 'Droid Sans',
		'Economica'              => 'Economica',
		'Fredoka One'            => 'Fredoka One',
		'Fjalla One'             => 'Fjalla One',
		'Francois One'           => 'Francois One',
		'Frank Ruhl Libre'       => 'Frank Ruhl Libre',
		'Gloria Hallelujah'      => 'Gloria Hallelujah',
		'Great Vibes'            => 'Great Vibes',
		'Handlee'                => 'Handlee',
		'Hammersmith One'        => 'Hammersmith One',
		'Inconsolata'            => 'Inconsolata',
		'Indie Flower'           => 'Indie Flower',
		'IM Fell English SC'     => 'IM Fell English SC',
		'Julius Sans One'        => 'Julius Sans One',
		'Josefin Slab'           => 'Josefin Slab',
		'Josefin Sans'           => 'Josefin Sans',
		'Kanit'                  => 'Kanit',
		'Lobster'                => 'Lobster',
		'Lato'                   => 'Lato',
		'Lora'                   => 'Lora',
		'Libre Baskerville'      => 'Libre Baskerville',
		'Lobster Two'            => 'Lobster Two',
		'Merriweather'           => 'Merriweather',
		'Monda'                  => 'Monda',
		'Montserrat'             => 'Montserrat',
		'Muli'                   => 'Muli',
		'Marck Script'           => 'Marck Script',
		'Noto Serif'             => 'Noto Serif',
		'Open Sans'              => 'Open Sans',
		'Overpass'               => 'Overpass',
		'Overpass Mono'          => 'Overpass Mono',
		'Oxygen'                 => 'Oxygen',
		'Orbitron'               => 'Orbitron',
		'Patua One'              => 'Patua One',
		'Pacifico'               => 'Pacifico',
		'Padauk'                 => 'Padauk',
		'Playball'               => 'Playball',
		'Playfair Display'       => 'Playfair Display',
		'PT Sans'                => 'PT Sans',
		'Philosopher'            => 'Philosopher',
		'Permanent Marker'       => 'Permanent Marker',
		'Poiret One'             => 'Poiret One',
		'Quicksand'              => 'Quicksand',
		'Quattrocento Sans'      => 'Quattrocento Sans',
		'Raleway'                => 'Raleway',
		'Rubik'                  => 'Rubik',
		'Rokkitt'                => 'Rokkitt',
		'Russo One'              => 'Russo One',
		'Righteous'              => 'Righteous',
		'Slabo'                  => 'Slabo',
		'Source Sans Pro'        => 'Source Sans Pro',
		'Shadows Into Light Two' => 'Shadows Into Light Two',
		'Shadows Into Light'     => 'Shadows Into Light',
		'Sacramento'             => 'Sacramento',
		'Shrikhand'              => 'Shrikhand',
		'Tangerine'              => 'Tangerine',
		'Ubuntu'                 => 'Ubuntu',
		'VT323'                  => 'VT323',
		'Varela Round'           => 'Varela Round',
		'Vampiro One'            => 'Vampiro One',
		'Vollkorn'               => 'Vollkorn',
		'Volkhov'                => 'Volkhov',
		'Yanone Kaffeesatz'      => 'Yanone Kaffeesatz'
	);

	//Typography
	$wp_customize->add_section('gym_training_coach_typography', array(
		'title'    => __('Typography', 'gym-training-coach'),
		'panel'    => 'gym_training_coach_panel_id',
	));

	//This is body FontFamily picker setting
	$wp_customize->add_setting('gym_training_coach_body_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_body_color', array(
		'label'    => __('Body Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_typography',
		'settings' => 'gym_training_coach_body_color',
	)));

	$wp_customize->add_setting('gym_training_coach_body_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices',
	));
	$wp_customize->add_control(	'gym_training_coach_body_font_family', array(
		'section' => 'gym_training_coach_typography',
		'label'   => __('Body Fonts', 'gym-training-coach'),
		'type'    => 'select',
		'choices' => $gym_training_coach_font_array,
	));

	$wp_customize->add_setting('gym_training_coach_body_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('gym_training_coach_body_font_size', array(
		'label'   => __('Body Font Size', 'gym-training-coach'),
		'section' => 'gym_training_coach_typography',
		'setting' => 'gym_training_coach_body_font_size',
		'type'    => 'text',
	));

	// This is Paragraph Color picker setting
	$wp_customize->add_setting('gym_training_coach_paragraph_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_paragraph_color', array(
		'label'    => __('Paragraph Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_typography',
		'settings' => 'gym_training_coach_paragraph_color',
	)));

	//This is Paragraph FontFamily picker setting
	$wp_customize->add_setting('gym_training_coach_paragraph_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices',
	));
	$wp_customize->add_control(	'gym_training_coach_paragraph_font_family', array(
		'section' => 'gym_training_coach_typography',
		'label'   => __('Paragraph Fonts', 'gym-training-coach'),
		'type'    => 'select',
		'choices' => $gym_training_coach_font_array,
	));

	$wp_customize->add_setting('gym_training_coach_paragraph_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('gym_training_coach_paragraph_font_size', array(
		'label'   => __('Paragraph Font Size', 'gym-training-coach'),
		'section' => 'gym_training_coach_typography',
		'setting' => 'gym_training_coach_paragraph_font_size',
		'type'    => 'text',
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting('gym_training_coach_atag_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_atag_color', array(
		'label'    => __('"a" Tag Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_typography',
		'settings' => 'gym_training_coach_atag_color',
	)));

	//This is "a" Tag FontFamily picker setting
	$wp_customize->add_setting('gym_training_coach_atag_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices',
	));
	$wp_customize->add_control(	'gym_training_coach_atag_font_family', array(
		'section' => 'gym_training_coach_typography',
		'label'   => __('"a" Tag Fonts', 'gym-training-coach'),
		'type'    => 'select',
		'choices' => $gym_training_coach_font_array,
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting('gym_training_coach_li_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_li_color', array(
		'label'    => __('"li" Tag Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_typography',
		'settings' => 'gym_training_coach_li_color',
	)));

	//This is "li" Tag FontFamily picker setting
	$wp_customize->add_setting('gym_training_coach_li_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices',
	));
	$wp_customize->add_control(	'gym_training_coach_li_font_family', array(
		'section' => 'gym_training_coach_typography',
		'label'   => __('"li" Tag Fonts', 'gym-training-coach'),
		'type'    => 'select',
		'choices' => $gym_training_coach_font_array,
	));

	// This is H1 Color picker setting
	$wp_customize->add_setting('gym_training_coach_h1_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_h1_color', array(
		'label'    => __('H1 Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_typography',
		'settings' => 'gym_training_coach_h1_color',
	)));

	//This is H1 FontFamily picker setting
	$wp_customize->add_setting('gym_training_coach_h1_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices',
	));
	$wp_customize->add_control('gym_training_coach_h1_font_family', array(
		'section' => 'gym_training_coach_typography',
		'label'   => __('H1 Fonts', 'gym-training-coach'),
		'type'    => 'select',
		'choices' => $gym_training_coach_font_array,
	));

	//This is H1 FontSize setting
	$wp_customize->add_setting('gym_training_coach_h1_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('gym_training_coach_h1_font_size', array(
		'label'   => __('H1 Font Size', 'gym-training-coach'),
		'section' => 'gym_training_coach_typography',
		'setting' => 'gym_training_coach_h1_font_size',
		'type'    => 'text',
	));

	// This is H2 Color picker setting
	$wp_customize->add_setting('gym_training_coach_h2_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_h2_color', array(
		'label'    => __('h2 Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_typography',
		'settings' => 'gym_training_coach_h2_color',
	)));

	//This is H2 FontFamily picker setting
	$wp_customize->add_setting('gym_training_coach_h2_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices',
	));
	$wp_customize->add_control(
	'gym_training_coach_h2_font_family', array(
		'section' => 'gym_training_coach_typography',
		'label'   => __('h2 Fonts', 'gym-training-coach'),
		'type'    => 'select',
		'choices' => $gym_training_coach_font_array,
	));

	//This is H2 FontSize setting
	$wp_customize->add_setting('gym_training_coach_h2_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('gym_training_coach_h2_font_size', array(
		'label'   => __('H2 Font Size', 'gym-training-coach'),
		'section' => 'gym_training_coach_typography',
		'setting' => 'gym_training_coach_h2_font_size',
		'type'    => 'text',
	));

	// This is H3 Color picker setting
	$wp_customize->add_setting('gym_training_coach_h3_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_h3_color', array(
		'label'    => __('H3 Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_typography',
		'settings' => 'gym_training_coach_h3_color',
	)));

	//This is H3 FontFamily picker setting
	$wp_customize->add_setting('gym_training_coach_h3_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices',
	));
	$wp_customize->add_control(
	'gym_training_coach_h3_font_family', array(
		'section' => 'gym_training_coach_typography',
		'label'   => __('H3 Fonts', 'gym-training-coach'),
		'type'    => 'select',
		'choices' => $gym_training_coach_font_array,
	));

	//This is H3 FontSize setting
	$wp_customize->add_setting('gym_training_coach_h3_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('gym_training_coach_h3_font_size', array(
		'label'   => __('H3 Font Size', 'gym-training-coach'),
		'section' => 'gym_training_coach_typography',
		'setting' => 'gym_training_coach_h3_font_size',
		'type'    => 'text',
	));

	// This is H4 Color picker setting
	$wp_customize->add_setting('gym_training_coach_h4_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_h4_color', array(
		'label'    => __('H4 Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_typography',
		'settings' => 'gym_training_coach_h4_color',
	)));

	//This is H4 FontFamily picker setting
	$wp_customize->add_setting('gym_training_coach_h4_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices',
	));
	$wp_customize->add_control('gym_training_coach_h4_font_family', array(
		'section' => 'gym_training_coach_typography',
		'label'   => __('H4 Fonts', 'gym-training-coach'),
		'type'    => 'select',
		'choices' => $gym_training_coach_font_array,
	));

	//This is H4 FontSize setting
	$wp_customize->add_setting('gym_training_coach_h4_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('gym_training_coach_h4_font_size', array(
		'label'   => __('H4 Font Size', 'gym-training-coach'),
		'section' => 'gym_training_coach_typography',
		'setting' => 'gym_training_coach_h4_font_size',
		'type'    => 'text',
	));

	// This is H5 Color picker setting
	$wp_customize->add_setting('gym_training_coach_h5_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_h5_color', array(
		'label'    => __('H5 Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_typography',
		'settings' => 'gym_training_coach_h5_color',
	)));

	//This is H5 FontFamily picker setting
	$wp_customize->add_setting('gym_training_coach_h5_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices',
	));
	$wp_customize->add_control('gym_training_coach_h5_font_family', array(
		'section' => 'gym_training_coach_typography',
		'label'   => __('H5 Fonts', 'gym-training-coach'),
		'type'    => 'select',
		'choices' => $gym_training_coach_font_array,
	));

	//This is H5 FontSize setting
	$wp_customize->add_setting('gym_training_coach_h5_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('gym_training_coach_h5_font_size', array(
		'label'   => __('H5 Font Size', 'gym-training-coach'),
		'section' => 'gym_training_coach_typography',
		'setting' => 'gym_training_coach_h5_font_size',
		'type'    => 'text',
	));

	// This is H6 Color picker setting
	$wp_customize->add_setting('gym_training_coach_h6_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_h6_color', array(
		'label'    => __('H6 Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_typography',
		'settings' => 'gym_training_coach_h6_color',
	)));

	//This is H6 FontFamily picker setting
	$wp_customize->add_setting('gym_training_coach_h6_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices',
	));
	$wp_customize->add_control('gym_training_coach_h6_font_family', array(
		'section' => 'gym_training_coach_typography',
		'label'   => __('H6 Fonts', 'gym-training-coach'),
		'type'    => 'select',
		'choices' => $gym_training_coach_font_array,
	));

	//This is H6 FontSize setting
	$wp_customize->add_setting('gym_training_coach_h6_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('gym_training_coach_h6_font_size', array(
		'label'   => __('H6 Font Size', 'gym-training-coach'),
		'section' => 'gym_training_coach_typography',
		'setting' => 'gym_training_coach_h6_font_size',
		'type'    => 'text',
	));

 	//Header Section
	$wp_customize->add_section('gym_training_coach_header_section',array(
		'title'	=> __('Header','gym-training-coach'),
		'description'	=> __('Add contact details here','gym-training-coach'),
		'priority'	=> null,
		'panel' => 'gym_training_coach_panel_id',
	));

	$wp_customize->add_setting('gym_training_coach_display_search',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ));

    $wp_customize->add_control('gym_training_coach_display_search',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Search','gym-training-coach'),
       'section' => 'gym_training_coach_header_section'
    ));

	//Show /Hide Topbar
	$wp_customize->add_setting( 'gym_training_coach_show_topbar',array(
		'default' => false,
      	'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ) );
    $wp_customize->add_control('gym_training_coach_show_topbar',array(
    	'type' => 'checkbox',
        'label' => __( 'Show / Hide Topbar','gym-training-coach' ),
        'section' => 'gym_training_coach_header_section'
    ));

	$wp_customize->add_setting('gym_training_coach_email_address',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_email'
 	));
 	$wp_customize->add_control('gym_training_coach_email_address',array(
		'type' => 'text',
		'label' => __('Add Email Address','gym-training-coach'),
		'section' => 'gym_training_coach_header_section',
	) );

	$wp_customize->add_setting('gym_training_coach_topbar_location',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('gym_training_coach_topbar_location',array(
		'type' => 'text',
		'label' => __('Add Location','gym-training-coach'),
		'section' => 'gym_training_coach_header_section',
	) );

	$wp_customize->add_setting('gym_training_coach_header_btn_text',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('gym_training_coach_header_btn_text',array(
		'type' => 'text',
		'label' => __('Add Phone Text','gym-training-coach'),
		'section' => 'gym_training_coach_header_section',
	) );

	$wp_customize->add_setting('gym_training_coach_phone_number',array(
		'default' => '',
		'sanitize_callback' => 'gym_training_coach_sanitize_phone_number'
 	));
 	$wp_customize->add_control('gym_training_coach_phone_number',array(
		'type' => 'text',
		'label' => __('Add Phone Number','gym-training-coach'),
		'section' => 'gym_training_coach_header_section',
	) );

 	//contact us Section
	$wp_customize->add_section('gym_training_coach_social_icon_section',array(
		'title'	=> __('Social Icons','gym-training-coach'),
		'priority'	=> null,
		'panel' => 'gym_training_coach_panel_id',
	));

	$wp_customize->add_setting( 'gym_training_coach_social_links',array(
		'default' => false,
      	'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ) );
    $wp_customize->add_control('gym_training_coach_social_links',array(
    	'type' => 'checkbox',
        'label' => __( 'Show / Hide Social Links','gym-training-coach' ),
        'section' => 'gym_training_coach_social_icon_section'
    ));

	$wp_customize->add_setting('gym_training_coach_facebook_url',array(
		'default' => '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('gym_training_coach_facebook_url',array(
		'type' => 'url',
		'label' => __('Add Facebook URL','gym-training-coach'),
		'section' => 'gym_training_coach_social_icon_section',
	));

	$wp_customize->add_setting('gym_training_coach_twitter_url',array(
		'default' => '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('gym_training_coach_twitter_url',array(
		'type' => 'url',
		'label' => __('Add Twitter URL','gym-training-coach'),
		'section' => 'gym_training_coach_social_icon_section',
	));

	$wp_customize->add_setting('gym_training_coach_instagram_url',array(
		'default' => '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('gym_training_coach_instagram_url',array(
		'type' => 'url',
		'label' => __('Add Instagram URL','gym-training-coach'),
		'section' => 'gym_training_coach_social_icon_section',
	));

	$wp_customize->add_setting('gym_training_coach_pinterest_url',array(
		'default' => '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('gym_training_coach_pinterest_url',array(
		'type' => 'url',
		'label' => __('Add Pinterest URL','gym-training-coach'),
		'section' => 'gym_training_coach_social_icon_section',
	));

	$wp_customize->add_setting('gym_training_coach_social_icon_font_size',array(
		'default'=> 12, 
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize,'gym_training_coach_social_icon_font_size',array(
		'label'	=> __('Social Icon Size','gym-training-coach'),
		'section'=> 'gym_training_coach_social_icon_section',
		'input_attrs' => array(
         'step' => 1,
			'min'  => 0,
			'max'  => 50,
     	),
	)));

	//Menu Settings
	$wp_customize->add_section('gym_training_coach_menu_settings',array(
		'title'	=> __('Menu Settings','gym-training-coach'),
		'priority'	=> null,
		'panel' => 'gym_training_coach_panel_id',
	));

	$wp_customize->add_setting('gym_training_coach_menu_font_size_option',array(
		'default'=> 14, 
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize,'gym_training_coach_menu_font_size_option',array(
		'label'	=> __('Menu Font Size','gym-training-coach'),
		'section'=> 'gym_training_coach_menu_settings',
		'input_attrs' => array(
         'step' => 1,
			'min'  => 0,
			'max'  => 50,
     	),
	)));

	$wp_customize->add_setting('gym_training_coach_top_bottom_padding',array(
		'default'=> 8,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize,'gym_training_coach_top_bottom_padding',array(
		'label'	=> __('Menu Top-Bottom Padding','gym-training-coach'),
		'section'=> 'gym_training_coach_menu_settings',
		'input_attrs' => array(
         'step' => 1,
			'min'  => 0,
			'max'  => 50,
      ),
	)));

	$wp_customize->add_setting('gym_training_coach_left_right_padding',array(
		'default'=> 20,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize,'gym_training_coach_left_right_padding',array(
		'label'	=> __('Menu Left-Right Padding','gym-training-coach'),
		'section'=> 'gym_training_coach_menu_settings',
		'input_attrs' => array(
         'step' => 1,
			'min'  => 0,
			'max'  => 50,
      ),
	)));

	$wp_customize->add_setting('gym_training_coach_text_tranform_menu',array(
		'default' => 'Capitalize',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices'
 	));
 	$wp_customize->add_control('gym_training_coach_text_tranform_menu',array(
		'type' => 'select',
		'label' => __('Menu Text Transform','gym-training-coach'),
		'section' => 'gym_training_coach_menu_settings',
		'choices' => array(
		   'Uppercase' => __('Uppercase','gym-training-coach'),
		   'Lowercase' => __('Lowercase','gym-training-coach'),
		   'Capitalize' => __('Capitalize','gym-training-coach'),
		),
	) );

	$wp_customize->add_setting('gym_training_coach_font_weight_option_menu',array(
		'default' => '600',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices'
 	));
 	$wp_customize->add_control('gym_training_coach_font_weight_option_menu',array(
		'type' => 'select',
		'label' => __('Menu Font Weight','gym-training-coach'),
		'section' => 'gym_training_coach_menu_settings',
		'choices' => array(
		   '100' => __('100','gym-training-coach'),
         '200' => __('200','gym-training-coach'),
         '300' => __('300','gym-training-coach'),
         '400' => __('400','gym-training-coach'),
         '500' => __('500','gym-training-coach'),
         '600' => __('600','gym-training-coach'),
         '700' => __('700','gym-training-coach'),
         '800' => __('800','gym-training-coach'),
         '900' => __('900','gym-training-coach'),
		),
	) );

	$wp_customize->add_setting('gym_training_coach_menu_color', array(
		'default'           => '#000',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_menu_color', array(
		'label'    => __('Menu Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_menu_settings',
		'settings' => 'gym_training_coach_menu_color',
	)));

	$wp_customize->add_setting('gym_training_coach_sub_menu_color', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_sub_menu_color', array(
		'label'    => __('Submenu Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_menu_settings',
		'settings' => 'gym_training_coach_sub_menu_color',
	)));

	$wp_customize->add_setting('gym_training_coach_menu_hover_color', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_menu_hover_color', array(
		'label'    => __('Menu Hover Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_menu_settings',
		'settings' => 'gym_training_coach_menu_hover_color',
	)));

	$wp_customize->add_setting('gym_training_coach_sub_menu_hover_color', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_sub_menu_hover_color', array(
		'label'    => __('Submenu Hover Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_menu_settings',
		'settings' => 'gym_training_coach_sub_menu_hover_color',
	)));

	$wp_customize->add_setting('gym_training_coach_sub_menu_bg_color', array(
		'default'           => '#F6551C',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_sub_menu_bg_color', array(
		'label'    => __('Submenu Background Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_menu_settings',
		'settings' => 'gym_training_coach_sub_menu_bg_color',
	)));

	$wp_customize->add_setting('gym_training_coach_sub_menu_bg_hover_color', array(
		'default'           => '#000',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_sub_menu_bg_hover_color', array(
		'label'    => __('Submenu Background Hover Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_menu_settings',
		'settings' => 'gym_training_coach_sub_menu_bg_hover_color',
	)));

	//Slider Section
	$wp_customize->add_section( 'gym_training_coach_slider_section' , array(
    	'title'      => __( 'Slider Section', 'gym-training-coach' ),
		'priority'   => null,
		'panel' => 'gym_training_coach_panel_id'
	) );

	$wp_customize->add_setting('gym_training_coach_slider_hide',array(
		'default' => false,
		'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
	));
	$wp_customize->add_control('gym_training_coach_slider_hide',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable slider','gym-training-coach'),
		'section' => 'gym_training_coach_slider_section',
	));

	for ( $count = 1; $count <= 4; $count++ ) {

		// Add color scheme setting and control.
		$wp_customize->add_setting( 'gym_training_coach_slider' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'gym_training_coach_sanitize_dropdown_pages'
		) );
		$wp_customize->add_control( 'gym_training_coach_slider' . $count, array(
			'label'    => __( 'Select Slide Image Page', 'gym-training-coach' ),
			'section'  => 'gym_training_coach_slider_section',
			'type'     => 'dropdown-pages'
		) );
	}

	$wp_customize->add_setting( 'gym_training_coach_slider_small_title', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'gym_training_coach_slider_small_title', array(
		'label'    => __( 'Add Slider Small Text', 'gym-training-coach' ),
		'input_attrs' => array(
            'placeholder' => __( 'STRONG IS BEAUTIFUL', 'gym-training-coach' ),
        ),
		'section'  => 'gym_training_coach_slider_section',
		'type'     => 'text'
	) );

	$wp_customize->add_setting('gym_training_coach_slider_heading',array(
		'default' => true,
		'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
	));
	$wp_customize->add_control('gym_training_coach_slider_heading',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Slider Heading','gym-training-coach'),
		'section' => 'gym_training_coach_slider_section'
	));

	$wp_customize->add_setting('gym_training_coach_slider_heading_color', array(
		'default'           => '#ffffff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_slider_heading_color', array(
		'label'    => __('Slider Heading Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_slider_section',
	)));

	$wp_customize->add_setting('gym_training_coach_slider_text',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
   ));
   $wp_customize->add_control('gym_training_coach_slider_text',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Slider Text','gym-training-coach'),
       'section' => 'gym_training_coach_slider_section'
   ));

	$wp_customize->add_setting('gym_training_coach_slider_text_color', array(
		'default'           => '#ffffff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_slider_text_color', array(
		'label'    => __('Slider Text Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_slider_section',
	)));

   $wp_customize->add_setting('gym_training_coach_show_slider_button',array(
	    'default' => true,
	    'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
	));
	$wp_customize->add_control('gym_training_coach_show_slider_button',array(
		 'type' => 'checkbox',
		 'label' => __('Show / Hide Slider Button','gym-training-coach'),
		 'section' => 'gym_training_coach_slider_section'
	));

	$wp_customize->add_setting('gym_training_coach_slider_button_text',array(
		'default'	=> __('Get Started','gym-training-coach'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_training_coach_slider_button_text',array(
		'label'	=> __('Slider Button Text','gym-training-coach'),
		'section'	=> 'gym_training_coach_slider_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('gym_training_coach_slider_button_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('gym_training_coach_slider_button_link',array(
		'label'	=> esc_html__('Add Button Link','gym-training-coach'),
		'section'=> 'gym_training_coach_slider_section',
		'type'=> 'url'
	));

	$wp_customize->add_setting('gym_training_coach_slider_btn_text_color', array(
		'default'           => '#ffffff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_slider_btn_text_color', array(
		'label'    => __('Slider Button Text Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_slider_section',
	)));

	$wp_customize->add_setting('gym_training_coach_slider_btn_bg_color', array(
		'default'           => '#F6551C',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_slider_btn_bg_color', array(
		'label'    => __('Slider Button Background Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_slider_section',
	)));

	$wp_customize->add_setting('gym_training_coach_slider_previous_icon',array(
		'default'	=> 'fas fa-arrow-left',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Icon_Changer(
        $wp_customize,'gym_training_coach_slider_previous_icon',array(
		'label'	=> __('Slider Previous Icon','gym-training-coach'),
		'transport' => 'refresh',
		'section'	=> 'gym_training_coach_slider_section',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('gym_training_coach_slider_next_icon',array(
		'default'	=> 'fas fa-arrow-right',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Icon_Changer(
        $wp_customize,'gym_training_coach_slider_next_icon',array(
		'label'	=> __('Slider Next Icon','gym-training-coach'),
		'transport' => 'refresh',
		'section'	=> 'gym_training_coach_slider_section',
		'type'		=> 'icon'
	)));

	//content layout
   $wp_customize->add_setting('gym_training_coach_slider_content_layout',array(
     		'default' => 'Left',
     		'sanitize_callback' => 'gym_training_coach_sanitize_choices'
	));
	$wp_customize->add_control('gym_training_coach_slider_content_layout',array(
        'type' => 'radio',
        'label' => __('Slider Content Layout','gym-training-coach'),
        'section' => 'gym_training_coach_slider_section',
        'choices' => array(
            'Center' => __('Center','gym-training-coach'),
            'Left' => __('Left','gym-training-coach'),
            'Right' => __('Right','gym-training-coach'),
        ),
	) );

	//Slider excerpt
	$wp_customize->add_setting( 'gym_training_coach_slider_excerpt_number', array(
		'default'              => 20,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'absint',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'gym_training_coach_slider_excerpt_number', array(
		'label'       => esc_html__( 'Slider Content Limit','gym-training-coach' ),
		'section'     => 'gym_training_coach_slider_section',
		'type'        => 'number',
		'settings'    => 'gym_training_coach_slider_excerpt_number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('gym_training_coach_enable_slider_overlay',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
   ));
   $wp_customize->add_control('gym_training_coach_enable_slider_overlay',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Slider Image Overlay','gym-training-coach'),
       'section' => 'gym_training_coach_slider_section'
   ));

	//Opacity
	$wp_customize->add_setting('gym_training_coach_slider_opacity',array(
		'default'           => '',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices'
	));
	$wp_customize->add_control( 'gym_training_coach_slider_opacity', array(
		'label'       => esc_html__( 'Slider Image Opacity','gym-training-coach' ),
		'section'     => 'gym_training_coach_slider_section',
		'type'        => 'select',
		'settings'    => 'gym_training_coach_slider_opacity',
		'choices' => array(
			'0' =>  esc_attr('0','gym-training-coach'),
			'0.1' =>  esc_attr('0.1','gym-training-coach'),
			'0.2' =>  esc_attr('0.2','gym-training-coach'),
			'0.3' =>  esc_attr('0.3','gym-training-coach'),
			'0.4' =>  esc_attr('0.4','gym-training-coach'),
			'0.5' =>  esc_attr('0.5','gym-training-coach'),
			'0.6' =>  esc_attr('0.6','gym-training-coach'),
			'0.7' =>  esc_attr('0.7','gym-training-coach'),
			'0.8' =>  esc_attr('0.8','gym-training-coach'),
			'0.9' =>  esc_attr('0.9','gym-training-coach')
		),
	));

	$wp_customize->add_setting('gym_training_coach_slider_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_training_coach_slider_premium_info',array(
		'type'=> 'hidden',
		'label'	=> __('Premium Features','gym-training-coach'),
		'description' => "<ul><li>You can change how many slides there are.</li><li>You can change the font family and the colours of headings and subheadings.</li><li>And so on...</li></ul><a target='_blank' href='". esc_url('https://www.buywptemplates.com/themes/training-coach-wordpress-theme/') ." '>Upgrade to Pro</a>",
		'section'=> 'gym_training_coach_slider_section'
	));
	
	//Classes
  	$wp_customize->add_section('gym_training_coach_classes_section',array(
		'title' => __('Classes Section','gym-training-coach'),
		'description' => '',
		'priority'  => null,
		'panel' => 'gym_training_coach_panel_id',
	));

	$wp_customize->add_setting('gym_training_coach_product_enable',array(
		'default' => false,
		'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
	));
	$wp_customize->add_control('gym_training_coach_product_enable',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Classes Section','gym-training-coach'),
		'section' => 'gym_training_coach_classes_section'
	));

	$wp_customize->add_setting('gym_training_coach_section_title',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_training_coach_section_title',array(
		'type' => 'text',
		'label' => __('Section Title','gym-training-coach'),
		'section' => 'gym_training_coach_classes_section'
	));

	$wp_customize->add_setting('gym_training_coach_section_text',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_training_coach_section_text',array(
		'type' => 'text',
		'label' => __('Section Text','gym-training-coach'),
		'section' => 'gym_training_coach_classes_section'
	));

 	$categories = get_categories( );
 	$cats = array();
 	$i = 0;
 	foreach($categories as $category){
     	if($i==0){
         $default = $category->slug;
         $i++;
     	}
     $cats[$category->slug] = $category->name;
 	}
 	$wp_customize->add_setting('gym_training_coach_events_category',array(
     	'sanitize_callback' => 'gym_training_coach_sanitize_choices',
 	));
	$wp_customize->add_control('gym_training_coach_events_category',array(
		'type'    => 'select',
		'choices' => $cats,
		'label' => __('Select Classes Category','gym-training-coach'),
		'section' => 'gym_training_coach_classes_section',
 	));

	$wp_customize->add_setting('gym_training_coach_events_sec_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_training_coach_events_sec_premium_info',array(
		'type'=> 'hidden',
		'label'	=> __('Premium Features','gym-training-coach'),
		'description' => "<ul><li>Includes settings to set section title.</li><li>Contains settings for the background colour.</li><li>Contains options for background images.</li><li>You can change the font family and colours of heading.</li><li>And so on...</li></ul><a target='_blank' href='". esc_url('https://www.buywptemplates.com/themes/training-coach-wordpress-theme/') ." '>Upgrade to Pro</a>",
		'section'=> 'gym_training_coach_classes_section'
	));

	//layout setting
	$wp_customize->add_section( 'gym_training_coach_option', array(
    	'title'      => __( 'Layout Settings', 'gym-training-coach' ),
    	'panel'    => 'gym_training_coach_panel_id',
	) );

	$wp_customize->add_setting( 'gym_training_coach_single_page_breadcrumb',array(
	    'default' => false,
    	'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
  ) );
	$wp_customize->add_control('gym_training_coach_single_page_breadcrumb',array(
	    	'type' => 'checkbox',
	       'label' => __( 'Show / Hide Single Page Breadcrumb','gym-training-coach' ),
	       'section' => 'gym_training_coach_option'
	 ));

	$wp_customize->add_setting('gym_training_coach_preloader',array(
       'default' => false,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ));
    $wp_customize->add_control('gym_training_coach_preloader',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Preloader','gym-training-coach'),
       'section' => 'gym_training_coach_option'
    ));

   $wp_customize->add_setting('gym_training_coach_preloader_type',array(
     	'default' => 'First Preloader Type',
     	'sanitize_callback' => 'gym_training_coach_sanitize_choices'
	));
	$wp_customize->add_control('gym_training_coach_preloader_type',array(
      'type' => 'radio',
      'label' => __('Preloader Types','gym-training-coach'),
      'section' => 'gym_training_coach_option',
      'choices' => array(
         'First Preloader Type' => __('First Preloader Type','gym-training-coach'),
         'Second Preloader Type' => __('Second Preloader Type','gym-training-coach'),
      ),
	) );

	$wp_customize->add_setting('gym_training_coach_preloader_bg_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'gym_training_coach_preloader_bg_image',array(
        'label' => __('Preloader Background Image','gym-training-coach'),
        'section' => 'gym_training_coach_option'
	)));

	$wp_customize->add_setting('gym_training_coach_preloader_bg_color_option', array(
		'default'           => '#F6551C',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_preloader_bg_color_option', array(
		'label'    => __('Preloader Background Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_option',
	)));

	$wp_customize->add_setting('gym_training_coach_preloader_icon_color_option', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_preloader_icon_color_option', array(
		'label'    => __('Preloader Icon Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_option',
	)));

	$wp_customize->add_setting('gym_training_coach_width_layout_options',array(
		'default' => 'Default',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices'
	));
	$wp_customize->add_control('gym_training_coach_width_layout_options',array(
		'type' => 'radio',
		'label' => __('Container Box','gym-training-coach'),
		'description' => __('Here you can change the Width layout. ','gym-training-coach'),
		'section' => 'gym_training_coach_option',
		'choices' => array(
		   'Default' => __('Default','gym-training-coach'),
		   'Container Layout' => __('Container Layout','gym-training-coach'),
		   'Box Layout' => __('Box Layout','gym-training-coach'),
		),
	) );

	// Add Page sidebar Layout
	$wp_customize->add_setting('gym_training_coach_page_options',array(
        'default' => 'One Column',
        'sanitize_callback' => 'gym_training_coach_sanitize_choices'
	) );
	$wp_customize->add_control('gym_training_coach_page_options', array(
        'type' => 'select',
        'label' => __('Page Sidebar Layout','gym-training-coach'),
        'section' => 'gym_training_coach_option',
        'choices' => array(
            'One Column' => __('One Column','gym-training-coach'),
            'Left Sidebar' => __('Left Sidebar','gym-training-coach'),
            'Right Sidebar' => __('Right Sidebar','gym-training-coach')
        ),
	)   );

	// Add Settings and Controls for Layout
	$wp_customize->add_setting('gym_training_coach_layout_options',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'gym_training_coach_sanitize_choices'
	) );
	$wp_customize->add_control('gym_training_coach_layout_options', array(
        'type' => 'select',
        'label' => __('Post Sidebar Layout','gym-training-coach'),
        'section' => 'gym_training_coach_option',
        'choices' => array(
            'One Column' => __('One Column','gym-training-coach'),
            'Three Columns' => __('Three Columns','gym-training-coach'),
            'Four Columns' => __('Four Columns','gym-training-coach'),
            'Grid Layout' => __('Grid Layout','gym-training-coach'),
            'Left Sidebar' => __('Left Sidebar','gym-training-coach'),
            'Right Sidebar' => __('Right Sidebar','gym-training-coach')
        ),
	)   );

	$wp_customize->add_setting('gym_training_coach_sidebar_size',array(
        'default' => 'Sidebar 1/3',
        'sanitize_callback' => 'gym_training_coach_sanitize_choices'
	));
	$wp_customize->add_control('gym_training_coach_sidebar_size',array(
        'type' => 'radio',
        'label' => __('Sidebar Size Option','gym-training-coach'),
        'section' => 'gym_training_coach_option',
        'choices' => array(
            'Sidebar 1/3' => __('Sidebar 1/3','gym-training-coach'),
            'Sidebar 1/4' => __('Sidebar 1/4','gym-training-coach'),
        ),
	) );

   //Global Color
	$wp_customize->add_section('gym_training_coach_global_color', array(
		'title'    => __('Theme Color Option', 'gym-training-coach'),
		'panel'    => 'gym_training_coach_panel_id',
	));

	$wp_customize->add_setting('gym_training_coach_first_color', array(
		'default'           => '#F6551C',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_first_color', array(
		'label'    => __('Highlight Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_global_color',
		'settings' => 'gym_training_coach_first_color',
	)));

	//Blog Post Settings
	$wp_customize->add_section('gym_training_coach_post_settings', array(
		'title'    => __('Post General Settings', 'gym-training-coach'),
		'panel'    => 'gym_training_coach_panel_id',
	));

	$wp_customize->add_setting('gym_training_coach_post_layouts',array(
     'default' => 'Layout 2',
     'sanitize_callback' => 'gym_training_coach_sanitize_choices'
	));
	$wp_customize->add_control('gym_training_coach_post_layouts', array(
		'type' => 'select',
		'label' => __('Post Layouts','gym-training-coach'),
		'description' => __('Here you can change the 3 different layouts of post','gym-training-coach'),
		'section' => 'gym_training_coach_post_settings',
		'choices' => array(
		   'Layout 1' => __('Layouts 1','gym-training-coach'),
		   'Layout 2' => __('Layouts 2','gym-training-coach'),
		   'Layout 3' => __('Layouts 3','gym-training-coach'),
	)));

	$wp_customize->add_setting('gym_training_coach_metafields_date',array(
		'default' => true,
		'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
	));
	$wp_customize->add_control('gym_training_coach_metafields_date',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Date ','gym-training-coach'),
		'section' => 'gym_training_coach_post_settings'
	));

	$wp_customize->add_setting('gym_training_coach_post_date_icon',array(
		'default'	=> 'far fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Icon_Changer(
        $wp_customize,'gym_training_coach_post_date_icon',array(
		'label'	=> __('Post Date Icon','gym-training-coach'),
		'transport' => 'refresh',
		'section'	=> 'gym_training_coach_post_settings',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('gym_training_coach_metafields_author',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ));
    $wp_customize->add_control('gym_training_coach_metafields_author',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Author','gym-training-coach'),
       'section' => 'gym_training_coach_post_settings'
    ));

    $wp_customize->add_setting('gym_training_coach_post_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Icon_Changer(
        $wp_customize,'gym_training_coach_post_author_icon',array(
		'label'	=> __('Post Author Icon','gym-training-coach'),
		'transport' => 'refresh',
		'section'	=> 'gym_training_coach_post_settings',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('gym_training_coach_metafields_comment',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ));
    $wp_customize->add_control('gym_training_coach_metafields_comment',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Comments','gym-training-coach'),
       'section' => 'gym_training_coach_post_settings'
    ));

    $wp_customize->add_setting('gym_training_coach_post_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Icon_Changer(
        $wp_customize,'gym_training_coach_post_comment_icon',array(
		'label'	=> __('Post Comment Icon','gym-training-coach'),
		'transport' => 'refresh',
		'section'	=> 'gym_training_coach_post_settings',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('gym_training_coach_metafields_time',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ));
    $wp_customize->add_control('gym_training_coach_metafields_time',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Time','gym-training-coach'),
       'section' => 'gym_training_coach_post_settings'
    ));

    $wp_customize->add_setting('gym_training_coach_post_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Icon_Changer(
        $wp_customize,'gym_training_coach_post_time_icon',array(
		'label'	=> __('Post Time Icon','gym-training-coach'),
		'transport' => 'refresh',
		'section'	=> 'gym_training_coach_post_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('gym_training_coach_post_block_option',array(
        'default' => 'By Block',
        'sanitize_callback' => 'gym_training_coach_sanitize_choices'
	));
	$wp_customize->add_control('gym_training_coach_post_block_option',array(
        'type' => 'select',
        'label' => __('Blog Post Shown','gym-training-coach'),
        'section' => 'gym_training_coach_post_settings',
        'choices' => array(
            'By Block' => __('By Block','gym-training-coach'),
            'By Without Block' => __('By Without Block','gym-training-coach'),
        ),
	) );

	$wp_customize->add_setting('gym_training_coach_post_featured_image',array(
       'default' => 'Image',
       'sanitize_callback'	=> 'gym_training_coach_sanitize_choices'
   ));
   $wp_customize->add_control('gym_training_coach_post_featured_image',array(
       'type' => 'select',
       'label'	=> __('Post Image Options','gym-training-coach'),
       'choices' => array(
            'Image' => __('Image','gym-training-coach'),
            'Color' => __('Color','gym-training-coach'),
            'None' => __('None','gym-training-coach'),
        ),
      	'section'	=> 'gym_training_coach_post_settings',
   ));

   $wp_customize->add_setting( 'gym_training_coach_image_border_radius', array(
		'default'=> 0,
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize,  'gym_training_coach_image_border_radius', array(
		'label'       => esc_html__( 'Featured Image Border Radius','gym-training-coach' ),
		'section'     => 'gym_training_coach_post_settings',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	)) );

	$wp_customize->add_setting( 'gym_training_coach_image_box_shadow',array(
		'default' => 0,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'absint',
		'sanitize_js_callback' => 'absint',
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize,  'gym_training_coach_image_box_shadow',array(
		'label' => esc_html__( 'Featured Image Shadow','gym-training-coach' ),
		'section' => 'gym_training_coach_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
		'type'		=> 'range'
	)));

    $wp_customize->add_setting('gym_training_coach_post_featured_color', array(
		'default'           => '#F6551C',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_post_featured_color', array(
		'label'    => __('Post Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_post_settings',
		'settings' => 'gym_training_coach_post_featured_color',
		'active_callback' => 'gym_training_coach_post_color_enabled'
	)));

	$wp_customize->add_setting( 'gym_training_coach_custom_post_color_width',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_custom_post_color_width',	array(
		'label' => esc_html__( 'Color Post Custom Width','gym-training-coach' ),
		'section' => 'gym_training_coach_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 500,
			'step' => 1,
		),
		'active_callback' => 'gym_training_coach_show_post_color'
	)));

	$wp_customize->add_setting( 'gym_training_coach_custom_post_color_height',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_custom_post_color_height',array(
		'label' => esc_html__( 'Color Post Custom Height','gym-training-coach' ),
		'section' => 'gym_training_coach_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 350,
			'step' => 1,
		),
		'active_callback' => 'gym_training_coach_show_post_color'
	)));

	$wp_customize->add_setting('gym_training_coach_post_featured_image_dimention',array(
       'default' => 'Default',
       'sanitize_callback'	=> 'gym_training_coach_sanitize_choices'
    ));
    $wp_customize->add_control('gym_training_coach_post_featured_image_dimention',array(
       'type' => 'select',
       'label'	=> __('Post Featured Image Dimention','gym-training-coach'),
       'choices' => array(
            'Default' => __('Default','gym-training-coach'),
            'Custom' => __('Custom','gym-training-coach'),
        ),
      	'section'	=> 'gym_training_coach_post_settings',
      	'active_callback' => 'gym_training_coach_enable_post_featured_image'
    ));

    $wp_customize->add_setting( 'gym_training_coach_post_featured_image_custom_width',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_post_featured_image_custom_width',	array(
		'label' => esc_html__( 'Post Featured Image Custom Width','gym-training-coach' ),
		'section' => 'gym_training_coach_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 500,
			'step' => 1,
		),
		'active_callback' => 'gym_training_coach_enable_post_image_custom_dimention'
	)));

	$wp_customize->add_setting( 'gym_training_coach_post_featured_image_custom_height',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_post_featured_image_custom_height',	array(
		'label' => esc_html__( 'Post Featured Image Custom Height','gym-training-coach' ),
		'section' => 'gym_training_coach_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 350,
			'step' => 1,
		),
		'active_callback' => 'gym_training_coach_enable_post_image_custom_dimention'
	)));

	$wp_customize->add_setting('gym_training_coach_show_first_caps',array(
      'default' => false,
      'sanitize_callback' => 'gym_training_coach_sanitize_checkbox',
   ));
	$wp_customize->add_control( 'gym_training_coach_show_first_caps',array(
		'label' => esc_html__('First Cap (First Capital Letter)', 'gym-training-coach'),
		'type' => 'checkbox',
		'section' => 'gym_training_coach_post_settings',
	));

   //Post excerpt
	$wp_customize->add_setting( 'gym_training_coach_post_excerpt_number', array(
		'default'              => 30,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'absint',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'gym_training_coach_post_excerpt_number', array(
		'label'       => esc_html__( 'Blog Post Content Limit','gym-training-coach' ),
		'section'     => 'gym_training_coach_post_settings',
		'type'        => 'number',
		'settings'    => 'gym_training_coach_post_excerpt_number',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('gym_training_coach_content_settings',array(
        'default' =>'Excerpt',
        'sanitize_callback' => 'gym_training_coach_sanitize_choices'
	));
	$wp_customize->add_control('gym_training_coach_content_settings',array(
        'type' => 'radio',
        'label' => __('Content Settings','gym-training-coach'),
        'section' => 'gym_training_coach_post_settings',
        'choices' => array(
            'Excerpt' => __('Excerpt','gym-training-coach'),
            'Content' => __('Content','gym-training-coach'),
        ),
	) );

	$wp_customize->add_setting( 'gym_training_coach_post_discription_suffix', array(
		'default'   => __('[...]','gym-training-coach'),
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'gym_training_coach_post_discription_suffix', array(
		'label'       => esc_html__( 'Post Excerpt Suffix','gym-training-coach' ),
		'section'     => 'gym_training_coach_post_settings',
		'type'        => 'text',
		'settings'    => 'gym_training_coach_post_discription_suffix',
	) );

	$wp_customize->add_setting( 'gym_training_coach_blog_post_meta_seperator', array(
		'default'   => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'gym_training_coach_blog_post_meta_seperator', array(
		'label'       => esc_html__( 'Meta Box Separator','gym-training-coach' ),
		'section'     => 'gym_training_coach_post_settings',
		'description' => __('Here you can add the seperator for meta box. e.g. "|",  ",", "/", etc. ','gym-training-coach'),
		'type'        => 'text',
		'settings'    => 'gym_training_coach_blog_post_meta_seperator',
	) );

	$wp_customize->add_setting('gym_training_coach_enable_post_pagination',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ));
    $wp_customize->add_control('gym_training_coach_enable_post_pagination',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Blog Page Pagination','gym-training-coach'),
       'section' => 'gym_training_coach_post_settings'
    ));

    $wp_customize->add_setting( 'gym_training_coach_post_pagination_position', array(
        'default'			=>  'Bottom',
        'sanitize_callback'	=> 'gym_training_coach_sanitize_choices'
    ));
    $wp_customize->add_control( 'gym_training_coach_post_pagination_position', array(
        'section' => 'gym_training_coach_post_settings',
        'type' => 'select',
        'label' => __( 'Post Pagination Position', 'gym-training-coach' ),
        'choices'		=> array(
            'Top'  => __( 'Top', 'gym-training-coach' ),
            'Bottom' => __( 'Bottom', 'gym-training-coach' ),
            'Both Top & Bottom' => __( 'Both Top & Bottom', 'gym-training-coach' ),
    )));

	$wp_customize->add_setting( 'gym_training_coach_pagination_settings', array(
        'default'			=> 'Numeric Pagination',
        'sanitize_callback'	=> 'gym_training_coach_sanitize_choices'
    ));
    $wp_customize->add_control( 'gym_training_coach_pagination_settings', array(
        'section' => 'gym_training_coach_post_settings',
        'type' => 'radio',
        'label' => __( 'Post Pagination', 'gym-training-coach' ),
        'choices'		=> array(
            'Numeric Pagination'  => __( 'Numeric Pagination', 'gym-training-coach' ),
            'next-prev' => __( 'Next / Previous', 'gym-training-coach' ),
   )));

	//Button Settings
	$wp_customize->add_section('gym_training_coach_button_settings', array(
		'title'    => __('Button Settings', 'gym-training-coach'),
		'panel'    => 'gym_training_coach_panel_id',
	));

	$wp_customize->add_setting('gym_training_coach_button_text',array(
		'default'=> __('View More','gym-training-coach'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_training_coach_button_text',array(
		'label'	=> __('Add Button Text','gym-training-coach'),
		'section'=> 'gym_training_coach_button_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('gym_training_coach_btn_font_size_option',array(
		'default'=> 14,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize,'gym_training_coach_btn_font_size_option',array(
		'label'	=> __('Button Font Size','gym-training-coach'),
		'section'=> 'gym_training_coach_button_settings',
		'input_attrs' => array(
         'step' => 1,
			'min'  => 0,
			'max'  => 50,
     	),
	)));

	$wp_customize->add_setting('gym_training_coach_tranform_button_text',array(
		'default' => 'Capitalize',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices'
 	));
 	$wp_customize->add_control('gym_training_coach_tranform_button_text',array(
		'type' => 'select',
		'label' => __('Button Text Transform','gym-training-coach'),
		'section' => 'gym_training_coach_button_settings',
		'choices' => array(
		   'Uppercase' => __('Uppercase','gym-training-coach'),
		   'Lowercase' => __('Lowercase','gym-training-coach'),
		   'Capitalize' => __('Capitalize','gym-training-coach'),
		),
	) );

	$wp_customize->add_setting('gym_training_coach_button_font_weight',array(
		'default' => '500',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices'
 	));
 	$wp_customize->add_control('gym_training_coach_button_font_weight',array(
		'type' => 'select',
		'label' => __('Button Font Weight','gym-training-coach'),
		'section' => 'gym_training_coach_button_settings',
		'choices' => array(
			'100' => __('100','gym-training-coach'),
			'200' => __('200','gym-training-coach'),
			'300' => __('300','gym-training-coach'),
			'400' => __('400','gym-training-coach'),
			'500' => __('500','gym-training-coach'),
			'600' => __('600','gym-training-coach'),
			'700' => __('700','gym-training-coach'),
			'800' => __('800','gym-training-coach'),
			'900' => __('900','gym-training-coach'),
		),
	) );

	$wp_customize->add_setting( 'gym_training_coach_post_button_padding_top',array(
		'default' => 8,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_post_button_padding_top',	array(
		'label' => esc_html__( 'Button Top Bottom Padding (px)','gym-training-coach' ),
		'section' => 'gym_training_coach_button_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'gym_training_coach_post_button_padding_right',array(
		'default' => 20,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_post_button_padding_right',	array(
		'label' => esc_html__( 'Button Right Left Padding (px)','gym-training-coach' ),
		'section' => 'gym_training_coach_button_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'gym_training_coach_post_button_border_radius',array(
		'default' => 5,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_post_button_border_radius',array(
		'label' => esc_html__( 'Button Border Radius (px)','gym-training-coach' ),
		'section' => 'gym_training_coach_button_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

   //Single Post Settings
	$wp_customize->add_section('gym_training_coach_single_post_settings', array(
		'title'    => __('Single Post Settings', 'gym-training-coach'),
		'panel'    => 'gym_training_coach_panel_id',
	));

	$wp_customize->add_setting('gym_training_coach_single_post_bradcrumb',array(
			'default' => false,
			'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
		));
	$wp_customize->add_control('gym_training_coach_single_post_bradcrumb',array(
				'type' => 'checkbox',
				'label' => __('Enable / Disable Breadcrumb','gym-training-coach'),
				'section' => 'gym_training_coach_single_post_settings',
	));

	$wp_customize->add_setting('gym_training_coach_single_post_date',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ));
    $wp_customize->add_control('gym_training_coach_single_post_date',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Date ','gym-training-coach'),
       'section' => 'gym_training_coach_single_post_settings'
    ));

    $wp_customize->add_setting('gym_training_coach_single_post_date_icon',array(
		'default'	=> 'far fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control(new Gym_Training_Coach_Icon_Changer(
        $wp_customize,'gym_training_coach_single_post_date_icon',array(
		'label'	=> __('Single Post Date Icon','gym-training-coach'),
		'transport' => 'refresh',
		'section'	=> 'gym_training_coach_single_post_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('gym_training_coach_single_post_author',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ));
    $wp_customize->add_control('gym_training_coach_single_post_author',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Author','gym-training-coach'),
       'section' => 'gym_training_coach_single_post_settings'
    ));

   $wp_customize->add_setting('gym_training_coach_single_post_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Icon_Changer(
      $wp_customize,'gym_training_coach_single_post_author_icon',array(
		'label'	=> __('Single Post Author Icon','gym-training-coach'),
		'transport' => 'refresh',
		'section'	=> 'gym_training_coach_single_post_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('gym_training_coach_single_post_comment',array(
		'default' => true,
		'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
	));
	$wp_customize->add_control('gym_training_coach_single_post_comment',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Comments','gym-training-coach'),
		'section' => 'gym_training_coach_single_post_settings'
	));

 	$wp_customize->add_setting('gym_training_coach_single_post_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Icon_Changer( $wp_customize, 'gym_training_coach_single_post_comment_icon', array(
		'label'	=> __('Single Post Comment Icon','gym-training-coach'),
		'transport' => 'refresh',
		'section'	=> 'gym_training_coach_single_post_settings',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('gym_training_coach_single_post_time',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ));
    $wp_customize->add_control('gym_training_coach_single_post_time',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Time','gym-training-coach'),
       'section' => 'gym_training_coach_single_post_settings',
    ));

    $wp_customize->add_setting('gym_training_coach_single_post_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Icon_Changer(
        $wp_customize,'gym_training_coach_single_post_time_icon',array(
		'label'	=> __('Single Post Time Icon','gym-training-coach'),
		'transport' => 'refresh',
		'section'	=> 'gym_training_coach_single_post_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('gym_training_coach_post_comment_enable',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
   ));
   $wp_customize->add_control('gym_training_coach_post_comment_enable',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable post comment','gym-training-coach'),
       'section' => 'gym_training_coach_single_post_settings',
   ));

	$wp_customize->add_setting('gym_training_coach_single_post_featured_image',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
   ));
   $wp_customize->add_control('gym_training_coach_single_post_featured_image',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Featured image','gym-training-coach'),
       'section' => 'gym_training_coach_single_post_settings',
   ));

   $wp_customize->add_setting( 'gym_training_coach_single_image_border_radius', array(
		'default'=> 0,
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize,  'gym_training_coach_single_image_border_radius', array(
		'label'       => esc_html__( 'Featured Image Border Radius','gym-training-coach' ),
		'section'     => 'gym_training_coach_single_post_settings',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	)) );

	$wp_customize->add_setting( 'gym_training_coach_single_image_box_shadow',array(
		'default' => 0,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'absint',
		'sanitize_js_callback' => 'absint',
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize,  'gym_training_coach_single_image_box_shadow',array(
		'label' => esc_html__( 'Featured Image Shadow','gym-training-coach' ),
		'section' => 'gym_training_coach_single_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
		'type'		=> 'range'
	)));

	$wp_customize->add_setting('gym_training_coach_show_hide_single_post_categories',array(
			'default' => true,
			'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
   ));
   $wp_customize->add_control('gym_training_coach_show_hide_single_post_categories',array(
			'type' => 'checkbox',
			'label' => __('Single Post Categories','gym-training-coach'),
			'section' => 'gym_training_coach_single_post_settings'
   ));

	$wp_customize->add_setting('gym_training_coach_single_post_tags',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ));
    $wp_customize->add_control('gym_training_coach_single_post_tags',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Tags','gym-training-coach'),
       'section' => 'gym_training_coach_single_post_settings'
    ));

   $wp_customize->add_setting('gym_training_coach_category_color', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_category_color', array(
		'label'    => __('Category Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_single_post_settings',
		'settings' => 'gym_training_coach_category_color',
	)));

   $wp_customize->add_setting('gym_training_coach_category_hover_color', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_category_hover_color', array(
		'label'    => __('Category Hover Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_single_post_settings',
		'settings' => 'gym_training_coach_category_hover_color',
	)));

	$wp_customize->add_setting('gym_training_coach_single_post_layout',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'gym_training_coach_sanitize_choices'
	) );
	$wp_customize->add_control('gym_training_coach_single_post_layout', array(
        'type' => 'select',
        'label' => __('Select different Single post sidebar layout','gym-training-coach'),
        'section' => 'gym_training_coach_single_post_settings',
        'choices' => array(
            'One Column' => __('One Column','gym-training-coach'),
            'Left Sidebar' => __('Left Sidebar','gym-training-coach'),
            'Right Sidebar' => __('Right Sidebar','gym-training-coach')
        ),
	)   );

	$wp_customize->add_setting( 'gym_training_coach_single_post_meta_seperator', array(
		'default'   => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'gym_training_coach_single_post_meta_seperator', array(
		'label'       => esc_html__( 'Single Post Meta Box Seperator','gym-training-coach' ),
		'section'     => 'gym_training_coach_single_post_settings',
		'description' => __('Here you can add the seperator for meta box. e.g. "|",  ",", "/", etc. ','gym-training-coach'),
		'type'        => 'text',
		'settings'    => 'gym_training_coach_single_post_meta_seperator',
	) );

	$wp_customize->add_setting( 'gym_training_coach_comment_form_width',array(
		'default' => 100,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_comment_form_width',	array(
		'label' => esc_html__( 'Comment Form Width','gym-training-coach' ),
		'section' => 'gym_training_coach_single_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 100,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting('gym_training_coach_title_comment_form',array(
       'default' => __('Leave a Reply','gym-training-coach'),
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('gym_training_coach_title_comment_form',array(
       'type' => 'text',
       'label' => __('Comment Form Heading Text','gym-training-coach'),
       'section' => 'gym_training_coach_single_post_settings'
    ));

    $wp_customize->add_setting('gym_training_coach_comment_form_button_content',array(
       'default' => __('Post Comment','gym-training-coach'),
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('gym_training_coach_comment_form_button_content',array(
       'type' => 'text',
       'label' => __('Comment Form Button Text','gym-training-coach'),
       'section' => 'gym_training_coach_single_post_settings'
    ));

	$wp_customize->add_setting('gym_training_coach_enable_single_post_pagination',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
   ));
   $wp_customize->add_control('gym_training_coach_enable_single_post_pagination',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Single Post Pagination','gym-training-coach'),
       'section' => 'gym_training_coach_single_post_settings'
   ));

   $wp_customize->add_setting('gym_training_coach_prev_text',array(
       'default' => 'Previous page',
       'sanitize_callback'	=> 'sanitize_text_field'
   ));
   $wp_customize->add_control('gym_training_coach_prev_text',array(
       'type' => 'text',
       'label' => __('Previous Navigation Text','gym-training-coach'),
       'section' => 'gym_training_coach_single_post_settings'
   ));

   $wp_customize->add_setting('gym_training_coach_next_text',array(
       'default' => 'Next page',
       'sanitize_callback'	=> 'sanitize_text_field'
   ));
   $wp_customize->add_control('gym_training_coach_next_text',array(
       'type' => 'text',
       'label' => __('Next Navigation Text','gym-training-coach'),
       'section' => 'gym_training_coach_single_post_settings'
   ));

	//Related Post Settings
	$wp_customize->add_section('gym_training_coach_related_settings', array(
		'title'    => __('Related Post Settings', 'gym-training-coach'),
		'panel'    => 'gym_training_coach_panel_id',
	));

	$wp_customize->add_setting( 'gym_training_coach_related_enable_disable',array(
		'default' => true,
      	'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ) );
    $wp_customize->add_control('gym_training_coach_related_enable_disable',array(
    	'type' => 'checkbox',
        'label' => __( 'Enable / Disable Related Post','gym-training-coach' ),
        'section' => 'gym_training_coach_related_settings'
    ));

    $wp_customize->add_setting('gym_training_coach_related_title',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_training_coach_related_title',array(
		'label'	=> __('Add Section Title','gym-training-coach'),
		'section'	=> 'gym_training_coach_related_settings',
		'type'		=> 'text'
	));

	$wp_customize->add_setting( 'gym_training_coach_related_posts_count_number', array(
		'default'              => 3,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'gym_training_coach_related_posts_count_number', array(
		'label'       => esc_html__( 'Related Post Count','gym-training-coach' ),
		'section'     => 'gym_training_coach_related_settings',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 10,
		),
	) );

	$wp_customize->add_setting('gym_training_coach_related_posts_taxanomies',array(
        'default' => 'categories',
        'sanitize_callback' => 'gym_training_coach_sanitize_choices'
	));
	$wp_customize->add_control('gym_training_coach_related_posts_taxanomies',array(
        'type' => 'radio',
        'label' => __('Post Taxonomies','gym-training-coach'),
        'section' => 'gym_training_coach_related_settings',
        'choices' => array(
            'categories' => __('Categories','gym-training-coach'),
            'tags' => __('Tags','gym-training-coach'),
        ),
	) );

	$wp_customize->add_setting( 'gym_training_coach_related_post_excerpt_number',array(
		'default' => 15,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));

	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_related_post_excerpt_number',	array(
		'label' => esc_html__( 'Content Limit','gym-training-coach' ),
		'section' => 'gym_training_coach_related_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	//Responsive Media Settings
	$wp_customize->add_section('gym_training_coach_responsive_media',array(
		'title'	=> __('Responsive Media','gym-training-coach'),
		'panel' => 'gym_training_coach_panel_id',
	));

	$wp_customize->add_setting('gym_training_coach_responsive_menu_open_icon',array(
		'default'	=> 'fas fa-bars',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Icon_Changer(
        $wp_customize,'gym_training_coach_responsive_menu_open_icon',array(
		'label'	=> __('Responsive Open Menu Icon','gym-training-coach'),
		'transport' => 'refresh',
		'section'	=> 'gym_training_coach_responsive_media',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('gym_training_coach_open_menu_label',array(
       'default' => __('Menu','gym-training-coach'),
       'sanitize_callback'	=> 'sanitize_text_field'
   ));
   $wp_customize->add_control('gym_training_coach_open_menu_label',array(
       'type' => 'text',
       'label' => __('Open Menu Label','gym-training-coach'),
       'section' => 'gym_training_coach_responsive_media'
   ));

	$wp_customize->add_setting('gym_training_coach_responsive_menu_close_icon',array(
		'default'	=> 'fas fa-times',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Icon_Changer(
        $wp_customize,'gym_training_coach_responsive_menu_close_icon',array(
		'label'	=> __('Responsive Close Menu Icon','gym-training-coach'),
		'transport' => 'refresh',
		'section'	=> 'gym_training_coach_responsive_media',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('gym_training_coach_close_menu_label',array(
       'default' => __('Close Menu','gym-training-coach'),
       'sanitize_callback' => 'sanitize_text_field'
   ));
   $wp_customize->add_control('gym_training_coach_close_menu_label',array(
       'type' => 'text',
       'label' => __('Close Menu Label','gym-training-coach'),
       'section' => 'gym_training_coach_responsive_media'
   ));

	// site toggle button color
	$wp_customize->add_setting('gym_training_coach_toggle_button_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_toggle_button_color', array(
		'label'    => __('Toggle Button Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_responsive_media',
		'settings' => 'gym_training_coach_toggle_button_color',
	)));

	$wp_customize->add_setting('gym_training_coach_display_post_date',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ));
    $wp_customize->add_control('gym_training_coach_display_post_date',array(
       'type' => 'checkbox',
       'label' => __('Display Post Date','gym-training-coach'),
       'section' => 'gym_training_coach_responsive_media'
    ));

    $wp_customize->add_setting('gym_training_coach_display_post_author',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ));
    $wp_customize->add_control('gym_training_coach_display_post_author',array(
       'type' => 'checkbox',
       'label' => __('Display Post Author','gym-training-coach'),
       'section' => 'gym_training_coach_responsive_media'
    ));

    $wp_customize->add_setting('gym_training_coach_display_post_comment',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ));
    $wp_customize->add_control('gym_training_coach_display_post_comment',array(
       'type' => 'checkbox',
       'label' => __('Display Post Comment','gym-training-coach'),
       'section' => 'gym_training_coach_responsive_media'
    ));

    $wp_customize->add_setting('gym_training_coach_display_slider',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ));
    $wp_customize->add_control('gym_training_coach_display_slider',array(
       'type' => 'checkbox',
       'label' => __('Display Slider','gym-training-coach'),
       'section' => 'gym_training_coach_responsive_media'
    ));

	$wp_customize->add_setting('gym_training_coach_display_sidebar',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ));
    $wp_customize->add_control('gym_training_coach_display_sidebar',array(
       'type' => 'checkbox',
       'label' => __('Display Sidebar','gym-training-coach'),
       'section' => 'gym_training_coach_responsive_media'
    ));

    $wp_customize->add_setting('gym_training_coach_display_scrolltop',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ));
    $wp_customize->add_control('gym_training_coach_display_scrolltop',array(
       'type' => 'checkbox',
       'label' => __('Display Scroll To Top','gym-training-coach'),
       'section' => 'gym_training_coach_responsive_media'
    ));

    $wp_customize->add_setting('gym_training_coach_display_preloader',array(
       'default' => false,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
    ));
    $wp_customize->add_control('gym_training_coach_display_preloader',array(
       'type' => 'checkbox',
       'label' => __('Display Preloader','gym-training-coach'),
       'section' => 'gym_training_coach_responsive_media'
    ));

    //404 Page Setting
	$wp_customize->add_section('gym_training_coach_page_not_found',array(
		'title'	=> __('404 Page Not Found / No Result','gym-training-coach'),
		'panel' => 'gym_training_coach_panel_id',
	));

	$wp_customize->add_setting('gym_training_coach_page_not_found_heading',array(
		'default'=> __('404 Not Found','gym-training-coach'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_training_coach_page_not_found_heading',array(
		'label'	=> __('404 Heading','gym-training-coach'),
		'section'=> 'gym_training_coach_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('gym_training_coach_page_not_found_text',array(
		'default'=> __('Looks like you have taken a wrong turn. Dont worry it happens to the best of us.','gym-training-coach'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_training_coach_page_not_found_text',array(
		'label'	=> __('404 Content','gym-training-coach'),
		'section'=> 'gym_training_coach_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('gym_training_coach_page_not_found_button',array(
		'default'=>  __('Back to Home Page','gym-training-coach'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_training_coach_page_not_found_button',array(
		'label'	=> __('404 Button','gym-training-coach'),
		'section'=> 'gym_training_coach_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('gym_training_coach_no_search_result_heading',array(
		'default'=> __('Nothing Found','gym-training-coach'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('gym_training_coach_no_search_result_heading',array(
		'label'	=> __('No Search Results Heading','gym-training-coach'),
		'description'=>__('The search page heading display when no results are found.','gym-training-coach'),
		'section'=> 'gym_training_coach_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('gym_training_coach_no_search_result_text',array(
		'default'=> __('Sorry, but nothing matched your search terms. Please try again with some different keywords.','gym-training-coach'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_training_coach_no_search_result_text',array(
		'label'	=> __('No Search Results Text','gym-training-coach'),
		'description'=>__('The search page text display when no results are found.','gym-training-coach'),
		'section'=> 'gym_training_coach_page_not_found',
		'type'=> 'text'
	));

	//Woocommerce Section
	$wp_customize->add_section( 'gym_training_coach_woocommerce_section' , array(
    	'title'      => __( 'Woocommerce Settings', 'gym-training-coach' ),
    	'description'=>__('The below settings are apply on woocommerce pages.','gym-training-coach'),
		'priority'   => null,
		'panel' => 'gym_training_coach_panel_id'
	) );

	/**
	 * Product Columns
	 */
	$wp_customize->add_setting( 'gym_training_coach_per_columns' , array(
		'default'           => 3,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'gym_training_coach_per_columns', array(
		'label'    => __( 'Product per columns', 'gym-training-coach' ),
		'section'  => 'gym_training_coach_woocommerce_section',
		'type'     => 'select',
		'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
			'5' => '5',
		),
	) ) );

	$wp_customize->add_setting('gym_training_coach_product_per_page',array(
		'default'	=> 9,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_training_coach_product_per_page',array(
		'label'	=> __('Product per page','gym-training-coach'),
		'section'	=> 'gym_training_coach_woocommerce_section',
		'type'		=> 'number'
	));

	$wp_customize->add_setting('gym_training_coach_shop_sidebar_enable',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
   ));
   $wp_customize->add_control('gym_training_coach_shop_sidebar_enable',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable shop page sidebar','gym-training-coach'),
       'section' => 'gym_training_coach_woocommerce_section',
   ));

   // shop page sidebar alignment
   $wp_customize->add_setting('gym_training_coach_shop_page_layout', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices',
	));
	$wp_customize->add_control('gym_training_coach_shop_page_layout',array(
		'type'           => 'radio',
		'label'          => __('Shop Page Layout', 'gym-training-coach'),
		'section'        => 'gym_training_coach_woocommerce_section',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'gym-training-coach'),
			'Right Sidebar' => __('Right Sidebar', 'gym-training-coach'),
		),
	));

   $wp_customize->add_setting('gym_training_coach_product_page_sidebar_enable',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
   ));
   $wp_customize->add_control('gym_training_coach_product_page_sidebar_enable',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable product page sidebar','gym-training-coach'),
       'section' => 'gym_training_coach_woocommerce_section',
   ));

   // single product page sidebar alignment
   $wp_customize->add_setting('gym_training_coach_single_product_page_layout', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices',
	));
	$wp_customize->add_control('gym_training_coach_single_product_page_layout',array(
		'type'           => 'radio',
		'label'          => __('Single Product Page Layout', 'gym-training-coach'),
		'section'        => 'gym_training_coach_woocommerce_section',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'gym-training-coach'),
			'Right Sidebar' => __('Right Sidebar', 'gym-training-coach'),
		),
	));

   $wp_customize->add_setting('gym_training_coach_related_product_enable',array(
       'default' => true,
       'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
   ));
   $wp_customize->add_control('gym_training_coach_related_product_enable',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Related product','gym-training-coach'),
       'section' => 'gym_training_coach_woocommerce_section',
   ));

   $wp_customize->add_setting( 'gym_training_coach_woo_product_sale_border_radius',array(
		'default' => 0,
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_woo_product_sale_border_radius', array(
        'label'  => __('Woocommerce Product Sale Border Radius','gym-training-coach'),
        'section'  => 'gym_training_coach_woocommerce_section',
        'type'        => 'number',
        'input_attrs' => array(
        	'step'=> 1,
            'min' => 0,
            'max' => 50,
      )
   )));

    $wp_customize->add_setting('gym_training_coach_wooproduct_sale_font_size',array(
		'default'=> 14,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_wooproduct_sale_font_size',array(
		'label'	=> __('Woocommerce Product Sale Font Size','gym-training-coach'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'gym_training_coach_woocommerce_section',
	)));

    $wp_customize->add_setting('gym_training_coach_woo_product_sale_top_bottom_padding',array(
		'default'=> 0,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_woo_product_sale_top_bottom_padding',array(
		'label'	=> __('Woocommerce Product Sale Top Bottom Padding ','gym-training-coach'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'gym_training_coach_woocommerce_section',
		'type'=> 'number'
	)));

	$wp_customize->add_setting('gym_training_coach_woo_product_sale_left_right_padding',array(
		'default'=> 0,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_woo_product_sale_left_right_padding',array(
		'label'	=> __('Woocommerce Product Sale Left Right Padding','gym-training-coach'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'gym_training_coach_woocommerce_section',
		'type'=> 'number'
	)));

	$wp_customize->add_setting('gym_training_coach_woo_product_sale_position',array(
        'default' => 'Right',
        'sanitize_callback' => 'gym_training_coach_sanitize_choices'
	));
	$wp_customize->add_control('gym_training_coach_woo_product_sale_position',array(
        'type' => 'select',
        'label' => __('Woocommerce Product Sale Position','gym-training-coach'),
        'section' => 'gym_training_coach_woocommerce_section',
        'choices' => array(
            'Right' => __('Right','gym-training-coach'),
            'Left' => __('Left','gym-training-coach'),
        ),
	));

	$wp_customize->add_setting( 'gym_training_coach_woocommerce_button_padding_top',array(
		'default' => 12,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_woocommerce_button_padding_top',	array(
		'label' => esc_html__( 'Button Top Bottom Padding (px)','gym-training-coach' ),
		'section' => 'gym_training_coach_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'gym_training_coach_woocommerce_button_padding_right',array(
		'default' => 15,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_woocommerce_button_padding_right',	array(
		'label' => esc_html__( 'Button Right Left Padding (px)','gym-training-coach' ),
		'section' => 'gym_training_coach_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'gym_training_coach_woocommerce_button_border_radius',array(
		'default' => 0,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_woocommerce_button_border_radius',array(
		'label' => esc_html__( 'Button Border Radius (px)','gym-training-coach' ),
		'section' => 'gym_training_coach_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

   $wp_customize->add_setting('gym_training_coach_woocommerce_product_border_enable',array(
      'default' => false,
      'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
   ));
   $wp_customize->add_control('gym_training_coach_woocommerce_product_border_enable',array(
      'type' => 'checkbox',
      'label' => __('Enable / Disable product border','gym-training-coach'),
      'section' => 'gym_training_coach_woocommerce_section',
   ));

	$wp_customize->add_setting( 'gym_training_coach_woocommerce_product_padding_top',array(
		'default' => 0,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_woocommerce_product_padding_top',	array(
		'label' => esc_html__( 'Product Top Bottom Padding (px)','gym-training-coach' ),
		'section' => 'gym_training_coach_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'gym_training_coach_woocommerce_product_padding_right',array(
		'default' => 0,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_woocommerce_product_padding_right',	array(
		'label' => esc_html__( 'Product Right Left Padding (px)','gym-training-coach' ),
		'section' => 'gym_training_coach_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'gym_training_coach_woocommerce_product_border_radius',array(
		'default' => 3,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_woocommerce_product_border_radius',array(
		'label' => esc_html__( 'Product Border Radius (px)','gym-training-coach' ),
		'section' => 'gym_training_coach_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'gym_training_coach_woocommerce_product_box_shadow',array(
		'default' => 0,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_woocommerce_product_box_shadow',array(
		'label' => esc_html__( 'Product Box Shadow (px)','gym-training-coach' ),
		'section' => 'gym_training_coach_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting('gym_training_coach_wooproducts_nav',array(
       'default' => 'Yes',
       'sanitize_callback'	=> 'gym_training_coach_sanitize_choices'
    ));
    $wp_customize->add_control('gym_training_coach_wooproducts_nav',array(
       'type' => 'select',
       'label' => __('Shop Page Products Navigation','gym-training-coach'),
       'choices' => array(
            'Yes' => __('Yes','gym-training-coach'),
            'No' => __('No','gym-training-coach'),
        ),
       'section' => 'gym_training_coach_woocommerce_section',
    ));

	//footer text
	$wp_customize->add_section('gym_training_coach_footer_section',array(
		'title'	=> __('Footer Text','gym-training-coach'),
		'panel' => 'gym_training_coach_panel_id'
	));

	$wp_customize->add_setting('gym_training_coach_show_hide_footer',array(
		'default' => true,
		'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
	));
	$wp_customize->add_control('gym_training_coach_show_hide_footer',array(
     	'type' => 'checkbox',
      'label' => __('Enable / Disable Footer','gym-training-coach'),
      'section' => 'gym_training_coach_footer_section',
	));

	$wp_customize->add_setting('gym_training_coach_footer_bg_color', array(
		'default'           => '#0d0d0f',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_footer_bg_color', array(
		'label'    => __('Footer Background Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_footer_section',
	)));

	$wp_customize->add_setting('gym_training_coach_footer_bg_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'gym_training_coach_footer_bg_image',array(
		'label' => __('Footer Background Image','gym-training-coach'),
		'section' => 'gym_training_coach_footer_section'
	)));
	
	$wp_customize->add_setting('gym_training_coach_footer_attatchment',array(
		'default'=> 'scroll',
		'sanitize_callback'	=> 'gym_training_coach_sanitize_choices'
	));
	$wp_customize->add_control('gym_training_coach_footer_attatchment',array(
		'type' => 'select',
		'label'	=> __('Footer Background Attatchment','gym-training-coach'),
		'choices' => array(
            'fixed' => __('fixed','gym-training-coach'),
            'scroll' => __('scroll','gym-training-coach'),
        ),
		'section'=> 'gym_training_coach_footer_section',
	));

	$wp_customize->add_setting('gym_training_coach_footer_widget_areas',array(
		'default'           => 4,
		'sanitize_callback' => 'gym_training_coach_sanitize_choices',
	));
	$wp_customize->add_control('gym_training_coach_footer_widget_areas',array(
		'type'        => 'radio',
		'label'       => __('Footer widget area', 'gym-training-coach'),
		'section'     => 'gym_training_coach_footer_section',
		'description' => __('Select the number of widget areas you want in the footer. After that, go to Appearance > Widgets and add your widgets.', 'gym-training-coach'),
		'choices' => array(
		   '1'     => __('One', 'gym-training-coach'),
		   '2'     => __('Two', 'gym-training-coach'),
		   '3'     => __('Three', 'gym-training-coach'),
		   '4'     => __('Four', 'gym-training-coach')
		),
	));

	$wp_customize->add_setting('gym_training_coach_footer_heading_font_size',array(
		'default'=> 25,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_footer_heading_font_size',array(
		'label' => esc_html__( 'Footer Heading Font Size','gym-training-coach' ),
		'section'=> 'gym_training_coach_footer_section',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
	)));

	$wp_customize->add_setting('gym_training_coach_footer_heading_font_weight',array(
		'default' => '500',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices'
 	));
 	$wp_customize->add_control('gym_training_coach_footer_heading_font_weight',array(
		'type' => 'select',
		'label' => __('Footer Heading Font Weight','gym-training-coach'),
		'section' => 'gym_training_coach_footer_section',
		'choices' => array(
			'100' => __('100','gym-training-coach'),
			'200' => __('200','gym-training-coach'),
			'300' => __('300','gym-training-coach'),
			'400' => __('400','gym-training-coach'),
			'500' => __('500','gym-training-coach'),
			'600' => __('600','gym-training-coach'),
			'700' => __('700','gym-training-coach'),
			'800' => __('800','gym-training-coach'),
			'900' => __('900','gym-training-coach'),
		),
	) );

	$wp_customize->add_setting('gym_training_coach_footer_text_tranform',array(
		'default' => 'Capitalize',
		'sanitize_callback' => 'gym_training_coach_sanitize_choices'
 	));
 	$wp_customize->add_control('gym_training_coach_footer_text_tranform',array(
		'type' => 'select',
		'label' => __('Footer Widget Text Transform','gym-training-coach'),
		'section' => 'gym_training_coach_footer_section',
		'choices' => array(
		   'Uppercase' => __('Uppercase','gym-training-coach'),
		   'Lowercase' => __('Lowercase','gym-training-coach'),
		   'Capitalize' => __('Capitalize','gym-training-coach'),
		),
	) );

	$wp_customize->add_setting('gym_training_coach_footer_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize,'gym_training_coach_footer_padding',array(
		'label'	=> __('Footer Widget Padding','gym-training-coach'),
		'section'=> 'gym_training_coach_footer_section',
		'input_attrs' => array(
         'step' => 1,
			'min'  => 0,
			'max'  => 100,
      ),
	)));

	$wp_customize->add_setting('gym_training_coach_hide_show_scroll',array(
		'default' => true,
		'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
	));
	$wp_customize->add_control('gym_training_coach_hide_show_scroll',array(
     	'type' => 'checkbox',
      	'label' => __('Enable / Disable Back To Top','gym-training-coach'),
      	'section' => 'gym_training_coach_footer_section',
	));

	$wp_customize->add_setting('gym_training_coach_back_to_top_icon',array(
		'default'	=> 'fas fa-long-arrow-alt-up',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Icon_Changer(
        $wp_customize,'gym_training_coach_back_to_top_icon',array(
		'label'	=> __('Back to Top Icon','gym-training-coach'),
		'transport' => 'refresh',
		'section'	=> 'gym_training_coach_footer_section',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('gym_training_coach_scroll_icon_font_size',array(
		'default'=> 22,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_scroll_icon_font_size',array(
		'label'	=> __('Back To Top Icon Font Size','gym-training-coach'),
		'section'=> 'gym_training_coach_footer_section',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
	)));

	$wp_customize->add_setting('gym_training_coach_scroll_icon_color', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_scroll_icon_color', array(
		'label'    => __('Back to Top Icon Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_footer_section',
	)));

	$wp_customize->add_setting('gym_training_coach_scroll_icon_hover_color', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_scroll_icon_hover_color', array(
		'label'    => __('Back to Top Icon Hover Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_footer_section',
	)));

	$wp_customize->add_setting('gym_training_coach_scroll_icon_background', array(
		'default'           => '#F6551C',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_scroll_icon_background', array(
		'label'    => __('Back to Top Background Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_footer_section',
	)));

	$wp_customize->add_setting('gym_training_coach_scroll_icon_background_hover', array(
		'default'           => '#F6551C',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_scroll_icon_background_hover', array(
		'label'    => __('Back to Top Background Hover Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_footer_section',
	)));

	$wp_customize->add_setting('gym_training_coach_footer_options',array(
        'default' => 'Right align',
        'sanitize_callback' => 'gym_training_coach_sanitize_choices'
	));
	$wp_customize->add_control('gym_training_coach_footer_options',array(
        'type' => 'radio',
        'label' => __('Back To Top Alignment','gym-training-coach'),
        'section' => 'gym_training_coach_footer_section',
        'choices' => array(
            'Left align' => __('Left Align','gym-training-coach'),
            'Right align' => __('Right Align','gym-training-coach'),
            'Center align' => __('Center Align','gym-training-coach'),
        ),
	) );

	$wp_customize->add_setting( 'gym_training_coach_top_bottom_scroll_padding',array(
		'default' => 7,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_top_bottom_scroll_padding',	array(
		'label' => esc_html__( 'Top Bottom Scroll Padding (px)','gym-training-coach' ),
		'section' => 'gym_training_coach_footer_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'gym_training_coach_left_right_scroll_padding',array(
		'default' => 17,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_left_right_scroll_padding',	array(
		'label' => esc_html__( 'Left Right Scroll Padding (px)','gym-training-coach' ),
		'section' => 'gym_training_coach_footer_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'gym_training_coach_back_to_top_border_radius',array(
		'default' => 5,
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_back_to_top_border_radius', array(
		'label' => esc_html__( 'Back to Top Border Radius (px)','gym-training-coach' ),
		'section' => 'gym_training_coach_footer_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting('gym_training_coach_show_hide_copyright',array(
		'default' => true,
		'sanitize_callback'	=> 'gym_training_coach_sanitize_checkbox'
	));
	$wp_customize->add_control('gym_training_coach_show_hide_copyright',array(
     	'type' => 'checkbox',
      'label' => __('Enable / Disable Copyright','gym-training-coach'),
      'section' => 'gym_training_coach_footer_section',
	));

	$wp_customize->add_setting('gym_training_coach_footer_copy',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_training_coach_footer_copy',array(
		'label'	=> __('Copyright Text','gym-training-coach'),
		'section'	=> 'gym_training_coach_footer_section',
		'description'	=> __('Add some text for footer like copyright etc.','gym-training-coach'),
		'type'		=> 'text'
	));

	$wp_customize->add_setting('gym_training_coach_footer_text_align',array(
        'default' => 'center',
        'sanitize_callback' => 'gym_training_coach_sanitize_choices'
	));
	$wp_customize->add_control('gym_training_coach_footer_text_align',array(
        'type' => 'radio',
        'label' => __('Copyright Text Alignment ','gym-training-coach'),
        'section' => 'gym_training_coach_footer_section',
        'choices' => array(
            'left' => __('Left Align','gym-training-coach'),
            'right' => __('Right Align','gym-training-coach'),
            'center' => __('Center Align','gym-training-coach'),
        ),
	) );

	$wp_customize->add_setting('gym_training_coach_copyright_text_font_size',array(
		'default'=> 15,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control(new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_copyright_text_font_size',array(
		'label' => esc_html__( 'Copy right Font Size (px)','gym-training-coach' ),
		'section'=> 'gym_training_coach_footer_section',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
	)));

	$wp_customize->add_setting( 'gym_training_coach_footer_text_padding',array(
		'default' => 20,
		'transport' => 'refresh',
		'sanitize_callback' => 'gym_training_coach_sanitize_integer'
	));
	$wp_customize->add_control( new Gym_Training_Coach_Custom_Control( $wp_customize, 'gym_training_coach_footer_text_padding',	array(
		'label' => esc_html__( 'Copyright Text Padding (px)','gym-training-coach' ),
		'section' => 'gym_training_coach_footer_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting('gym_training_coach_copyright_text_color', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_copyright_text_color', array(
		'label'    => __('Copyright Text Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_footer_section',
	)));

	$wp_customize->add_setting('gym_training_coach_copyright_text_background', array(
		'default'           => '#F6551C',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_training_coach_copyright_text_background', array(
		'label'    => __('Copyright background Color', 'gym-training-coach'),
		'section'  => 'gym_training_coach_footer_section',
	)));

}
add_action( 'customize_register', 'gym_training_coach_customize_register' );

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Gym_Training_Coach_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Gym_Training_Coach_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Gym_Training_Coach_Customize_Section_Pro(
				$manager,
				'gym_training_coach_example_1',
				array(
					'title'   =>  esc_html__( 'Gym Training Coach Pro', 'gym-training-coach' ),
					'pro_text' => esc_html__( 'Go Pro', 'gym-training-coach' ),
					'pro_url'  => esc_url( 'https://www.buywptemplates.com/themes/training-coach-wordpress-theme/' ),
					'priority'   => 9
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'gym-training-coach-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'gym-training-coach-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/css/customize-controls.css' );
	}

	//Footer widget areas
	function gym_training_coach_sanitize_choices( $input ) {
	    $valid = array(
	        '1'     => __('One', 'gym-training-coach'),
	        '2'     => __('Two', 'gym-training-coach'),
	        '3'     => __('Three', 'gym-training-coach'),
	        '4'     => __('Four', 'gym-training-coach')
	    );
	    if ( array_key_exists( $input, $valid ) ) {
	        return $input;
	    } else {
	        return '';
	    }
	}
}

// Doing this customizer thang!
Gym_Training_Coach_Customize::get_instance();
