<?php

add_action( 'admin_menu', 'gym_training_coach_gettingstarted' );
function gym_training_coach_gettingstarted() {
	add_theme_page( esc_html__('About Theme', 'gym-training-coach'), esc_html__('About Theme', 'gym-training-coach'), 'edit_theme_options', 'gym-training-coach-guide-page', 'gym_training_coach_guide');
}

function gym_training_coach_admin_theme_style() {
   wp_enqueue_style('gym-training-coach-custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/dashboard/get_started_info.css');
}
add_action('admin_enqueue_scripts', 'gym_training_coach_admin_theme_style');

function gym_training_coach_notice(){
    global $pagenow;
    if ( is_admin() && ('themes.php' == $pagenow) && isset( $_GET['activated'] ) ) {?>
    <div class="notice notice-success is-dismissible getting_started">
		<div class="notice-content">
			<h2><?php esc_html_e( 'Thanks for installing Gym Training Coach, you rock!', 'gym-training-coach' ) ?> </h2>
			<p><?php esc_html_e( 'Take benefit of a variety of features, functionalities, elements, and an exclusive set of customization options to build your own professional automobile website. Please Click on the link below to know the theme setup information.', 'gym-training-coach' ) ?></p>
			<p><a href="<?php echo esc_url( admin_url( 'themes.php?page=gym-training-coach-guide-page' ) ); ?>" class="button button-primary"><?php esc_html_e( 'Getting Started', 'gym-training-coach' ); ?></a></p>
		</div>
	</div>
	<?php }
}
add_action('admin_notices', 'gym_training_coach_notice');

/**
 * Theme Info Page
 */
function gym_training_coach_guide() {

	// Theme info
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( 'gym-training-coach' ); ?>

	<div class="wrap getting-started">
		<div class="getting-started__header">
			<div class="row">
				<div class="col-md-5 intro">
					<div class="pad-box">
						<h2><?php esc_html_e( 'Welcome to Gym Training Coach', 'gym-training-coach' ); ?></h2>
						<p>Version: <?php echo esc_html($theme['Version']);?></p>
						<span class="intro__version"><?php esc_html_e( 'Congratulations! You are about to use the most easy to use and flexible WordPress theme.', 'gym-training-coach' ); ?>
						</span>
						<div class="powered-by">
							<p><strong><?php esc_html_e( 'Theme created by Buy WP Templates', 'gym-training-coach' ); ?></strong></p>
							<p>
								<img class="logo" src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/theme-logo.png'); ?>"/>
							</p>
						</div>
					</div>
				</div>
				<div class="col-md-7">
					<div class="pro-links">
				    	<a href="<?php echo esc_url( GYM_TRAINING_COACH_LIVE_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'gym-training-coach'); ?></a>
						<a href="<?php echo esc_url( GYM_TRAINING_COACH_BUY_PRO ); ?>" target="_blank"><?php esc_html_e('Buy Pro', 'gym-training-coach'); ?></a>
						<a href="<?php echo esc_url( GYM_TRAINING_COACH_PRO_DOC ); ?>" target="_blank"><?php esc_html_e('Pro Documentation', 'gym-training-coach'); ?></a>
					</div>
					<div class="install-plugins">
						<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/responsive1.png'); ?>" alt="" />
					</div>
				</div>
			</div>
			<h2 class="tg-docs-section intruction-title" id="section-4"><?php esc_html_e( '1). Setup Gym Training Coach Theme', 'gym-training-coach' ); ?></h2>
			<div class="row">
					<div class="theme-instruction-block col-md-7">
						<div class="pad-box">
		           <p><?php esc_html_e( 'This Gym Training Coach has a variety of superior performances and some remarkable points that collectively make a remarkable health internet site to make you stand aside from your competitors. We provide devoted help and time-to-time theme updates with it. It is responsive, cross-browser compatible, multilingual, retina-equipped, and web optimization enabled. An array of quite practical shortcodes are encompassed to put into effect points like video post, Instagram feed, gallery, multi-column layouts, etc., except writing strains of codes. This Gym Training Coach is customizable to its deepest core to get the wow look for your internet site on your conditions. Customization is easy and can be achieved via theme customizer, which takes only a few minutes to make changes. With its fluid layout, your internet site will be handy for mobiles, tablets, and laptops of distinctive sizes. The inclusion of social media icons makes advertising and marketing effortless and, as a result, will increase internet site attain to goal audience. With the flexibility to exchange the internet site diagram from boxed to full-width to full screen, you can exchange its sense from stylish to present-day to bold. This health theme has many widgetized areas place you can add practical blocks and various sections predesigned like gallery, testimonial, pricing table, subscription form, offerings, and others.', 'gym-training-coach' ); ?><p><br>
					        <ol>
								    <li><?php esc_html_e( 'Start','gym-training-coach'); ?> <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e( 'Customizing','gym-training-coach'); ?></a> <?php esc_html_e( 'your website.','gym-training-coach'); ?> </li>
								    <li><?php esc_html_e( 'Gym Training Coach','gym-training-coach'); ?> <a target="_blank" href="<?php echo esc_url( GYM_TRAINING_COACH_FREE_DOC ); ?>"><?php esc_html_e( 'Documentation','gym-training-coach'); ?></a> </li>
							    </ol>
	         </div>
	      </div>
				 <div class="col-md-5">
						<div class="pad-box">
								<img class="logo" src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/screenshot.png'); ?>"/>
						</div>
	      </div>
      </div>
			  <div class="col-md-12 text-block">
					<h2 class="dashboard-install-title"><?php esc_html_e( '2.) Premium Theme Information.','gym-training-coach'); ?></h2>
				   	<div class="row">
						<div class="col-md-7">
							<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/responsive.png'); ?>" alt="">
							<div class="pad-box">
								<h3><?php esc_html_e( 'Pro Theme Description','gym-training-coach'); ?></h3>
	                    		<p class="pad-box-p"><?php esc_html_e( 'Our premium Training Coach WordPress Theme is great on the web. We have labored challenging in weeding out problems and fixing the theme, thereby giving you the most pleasant product possible. Not solely that, our theme has a massive slider with a banner with a Call to Action Button (CTA) to entice visitors. It is well-matched with WooCommerce and incorporates elements & lovely layouts for products, posts, and pages. It is made with tightly closed and easy codes with hooks, shortcodes, and different add-on customization choices that permit you to customize your internet site besides writing a single strand of code. This pinnacle theme has been made on the Bootstrap four framework, simplifying the improvement process. This Training Coach WordPress Theme assesses all the containers concerning facets and functionalities. You can take a tour of the top rate by simply clicking on the demo button, properly to sum it all up, we would like to name it the most suitable. This one theme is for every health coach who needs to create an excellent first-class internet site and have a brilliant theme for existing worldwide.', 'gym-training-coach' ); ?><p>
	                    	</div>
						</div>
						<div class="col-md-5 install-plugin-right">
							<div class="pad-box">
								<h3><?php esc_html_e( 'Pro Theme Features','gym-training-coach'); ?></h3>
								<div class="dashboard-install-benefit">
									<ul>
										<li><?php esc_html_e( 'Theme options using customizer API','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Responsive design','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Site Icon and Logo option.','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Header Images option','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Favicon, Logo, title, and tagline customization','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Advanced Color options and color pallets','gym-training-coach'); ?></li>
										<li><?php esc_html_e( '100+ Font Family Options.','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Pagination option.','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Demo Importer.','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Enable-Disable options on All sections.','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Main Slider.','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Woocommerce Compatible.','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Unlimited Slides.','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Section to show categories.','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Product Listing based on category.','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Top Categories Section.','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Best Seller Tab.','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Testimonial with custom post type.','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Promotional Banners.','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Partner Listing.','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Shortcodes for Testimonials','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Newsletter with the help of contact form 7','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Well sanitized as per WordPress standards.','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Responsive layout for all devices','gym-training-coach'); ?></li>
										<li><?php esc_html_e( 'Typography for the complete website','gym-training-coach'); ?></li>
									</ul>
								</div>
							</div>
						</div>
				</div>
			</div>
		</div>
		<div class="dashboard__blocks">
			<div class="row">
				<div class="col-md-3">
					<h3><?php esc_html_e( 'Get Support','gym-training-coach'); ?></h3>
					<ol>
						<li><a target="_blank" href="<?php echo esc_url( GYM_TRAINING_COACH_FREE_SUPPORT ); ?>"><?php esc_html_e( 'Free Theme Support','gym-training-coach'); ?></a></li>
						<li><a target="_blank" href="<?php echo esc_url( GYM_TRAINING_COACH_PRO_SUPPORT ); ?>"><?php esc_html_e( 'Premium Theme Support','gym-training-coach'); ?></a></li>
					</ol>
				</div>

				<div class="col-md-3">
					<h3><?php esc_html_e( 'Getting Started','gym-training-coach'); ?></h3>
					<ol>
						<li><?php esc_html_e( 'Start','gym-training-coach'); ?> <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e( 'Customizing','gym-training-coach'); ?></a> <?php esc_html_e( 'your website.','gym-training-coach'); ?> </li>
					</ol>
				</div>
				<div class="col-md-3">
					<h3><?php esc_html_e( 'Help Docs','gym-training-coach'); ?></h3>
					<ol>
						<li><a target="_blank" href="<?php echo esc_url( GYM_TRAINING_COACH_FREE_DOC ); ?>"><?php esc_html_e( 'Free Theme Documentation','gym-training-coach'); ?></a></li>
						<li><a target="_blank" href="<?php echo esc_url( GYM_TRAINING_COACH_PRO_DOC ); ?>"><?php esc_html_e( 'Premium Theme Documentation','gym-training-coach'); ?></a></li>
					</ol>
				</div>
				<div class="col-md-3">
					<h3><?php esc_html_e( 'Buy Premium','gym-training-coach'); ?></h3>
					<ol>
						<a href="<?php echo esc_url( GYM_TRAINING_COACH_BUY_PRO ); ?>" target="_blank"><?php esc_html_e('Buy Pro', 'gym-training-coach'); ?></a>
					</ol>
				</div>
			</div>
		</div>
	</div>

<?php }?>
