<?php
/**
 * Nutrition Diet: Customizer-home-page
 *
 * @subpackage Nutrition Diet
 * @since 1.0
 */
	//  Home Page Panel
	$wp_customize->add_panel( 'nutrition_diet_custompage_panel', array(
		'title' => esc_html__( 'Custom Page Settings', 'nutrition-diet' ),
		'priority' => 2,
	));
	// Top Header
    $wp_customize->add_section('nutrition_diet_top',array(
        'title' => __('Header Settings', 'nutrition-diet'),
        'priority' => 2,
        'panel' => 'nutrition_diet_custompage_panel',
    ) );
    $wp_customize->add_setting( 'nutrition_diet_section_contact_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_contact_heading', array(
		'label'       => esc_html__( 'Header Settings', 'nutrition-diet' ),			
		'section'     => 'nutrition_diet_top',
		'settings'    => 'nutrition_diet_section_contact_heading',
	) ) );	
    $wp_customize->add_setting('nutrition_diet_call_number',array(
		'default' => '',
		'sanitize_callback' => 'nutrition_diet_sanitize_phone_number'
	));
	$wp_customize->add_control('nutrition_diet_call_number',array(
		'label' => esc_html__('Add Phone Number','nutrition-diet'),
		'section' => 'nutrition_diet_top',
		'setting' => 'nutrition_diet_call_number',
		'type'    => 'text',
	));
	$wp_customize->add_setting('nutrition_diet_call_icon',array(
		'default'	=> 'fas fa-phone',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Nutrition_Diet_Fontawesome_Icon_Chooser(
        $wp_customize,'nutrition_diet_call_icon',array(
		'label'	=> __('Add Phone Icon','nutrition-diet'),
		'transport' => 'refresh',
		'section'	=> 'nutrition_diet_top',
		'setting'	=> 'nutrition_diet_call_icon',
		'type'		=> 'icon',
	)));
	$wp_customize->selective_refresh->add_partial( 'nutrition_diet_call_number', array(
		'selector' => '.top_bar i',
		'render_callback' => 'nutrition_diet_customize_partial_nutrition_diet_call_number',
	) );
    $wp_customize->add_setting('nutrition_diet_email_address',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_email'
	));
	$wp_customize->add_control('nutrition_diet_email_address',array(
		'label' => esc_html__('Add Email Address','nutrition-diet'),
		'section' => 'nutrition_diet_top',
		'setting' => 'nutrition_diet_email_address',
		'type'    => 'text',
	));
	$wp_customize->add_setting('nutrition_diet_mail_icon',array(
		'default'	=> 'fas fa-envelope',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Nutrition_Diet_Fontawesome_Icon_Chooser(
        $wp_customize,'nutrition_diet_mail_icon',array(
		'label'	=> __('Add Email Icon','nutrition-diet'),
		'transport' => 'refresh',
		'section'	=> 'nutrition_diet_top',
		'setting'	=> 'nutrition_diet_mail_icon',
		'type'		=> 'icon',
	)));
    $wp_customize->add_setting('nutrition_diet_donate_btn_text',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('nutrition_diet_donate_btn_text',array(
		'label' => esc_html__('Add Button Text','nutrition-diet'),
		'section' => 'nutrition_diet_top',
		'setting' => 'nutrition_diet_donate_btn_text',
		'type'    => 'text',
	));
    $wp_customize->add_setting('nutrition_diet_donate_btn_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw'
	));
	$wp_customize->add_control('nutrition_diet_donate_btn_link',array(
		'label' => esc_html__('Add Button URL','nutrition-diet'),
		'section' => 'nutrition_diet_top',
		'setting' => 'nutrition_diet_donate_btn_link',
		'type'    => 'url',
	));

    //Slider
	$wp_customize->add_section( 'nutrition_diet_slider_section' , array(
    	'title'      => __( 'Slider Settings', 'nutrition-diet' ),
		'priority'   => 3,
		'panel' => 'nutrition_diet_custompage_panel',
	) );
	$wp_customize->add_setting( 'nutrition_diet_section_slide_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_slide_heading', array(
		'label'       => esc_html__( 'Slider Settings', 'nutrition-diet' ),
		'description' => __( 'Slider Image Dimension ( 600px x 700px )', 'nutrition-diet' ),		
		'section'     => 'nutrition_diet_slider_section',
		'settings'    => 'nutrition_diet_section_slide_heading',
	) ) );
	$wp_customize->add_setting(
		'nutrition_diet_slider_arrows',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_slider_arrows',
			array(
				'settings'        => 'nutrition_diet_slider_arrows',
				'section'         => 'nutrition_diet_slider_section',
				'label'           => __( 'Check To show Slider', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting('nutrition_diet_extra_text',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('nutrition_diet_extra_text',array(
		'label'	=> esc_html__('Section Extra Text ','nutrition-diet'),
		'section'	=> 'nutrition_diet_slider_section',
		'type'		=> 'text',
		'active_callback' => 'nutrition_diet_slider_dropdown'
	));

	$nutrition_diet_args = array('numberposts' => -1);
	$post_list = get_posts($nutrition_diet_args);
	$i = 0;
	$pst_sls[]= __('Select','nutrition-diet');
	foreach ($post_list as $key => $p_post) {
		$pst_sls[$p_post->ID]=$p_post->post_title;
	}
	for ( $i = 1; $i <= 4; $i++ ) {
		$wp_customize->add_setting('nutrition_diet_post_setting'.$i,array(
			'sanitize_callback' => 'nutrition_diet_sanitize_select',
		));
		$wp_customize->add_control('nutrition_diet_post_setting'.$i,array(
			'type'    => 'select',
			'choices' => $pst_sls,
			'label' => __('Select post','nutrition-diet'),
			'section' => 'nutrition_diet_slider_section',
			'active_callback' => 'nutrition_diet_slider_dropdown'
		));
		$wp_customize->selective_refresh->add_partial( 'nutrition_diet_post_setting'.$i, array(
			'selector' => '.carousel-control-prev',
			'render_callback' => 'nutrition_diet_customize_partial_nutrition_diet_post_setting'.$i,
		) );
	}
	wp_reset_postdata();

	$wp_customize->add_setting(
		'nutrition_diet_slider_excerpt_show_hide',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_slider_excerpt_show_hide',
			array(
				'settings'        => 'nutrition_diet_slider_excerpt_show_hide',
				'section'         => 'nutrition_diet_slider_section',
				'label'           => __( 'Show Hide excerpt', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => 'nutrition_diet_slider_dropdown',
			)
		)
	);
	$wp_customize->add_setting('nutrition_diet_slider_excerpt_count',array(
		'default'=> 20,
		'transport' => 'refresh',
		'sanitize_callback' => 'nutrition_diet_sanitize_integer'
	));
	$wp_customize->add_control(new Nutrition_Diet_Slider_Custom_Control( $wp_customize, 'nutrition_diet_slider_excerpt_count',array(
		'label' => esc_html__( 'Excerpt Limit','nutrition-diet' ),
		'section'=> 'nutrition_diet_slider_section',
		'settings'=>'nutrition_diet_slider_excerpt_count',
		'input_attrs' => array(
			'reset'			   => 20,
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
        'active_callback' => 'nutrition_diet_slider_dropdown',
	)));
	$wp_customize->add_setting(
		'nutrition_diet_slider_button_show_hide',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_slider_button_show_hide',
			array(
				'settings'        => 'nutrition_diet_slider_button_show_hide',
				'section'         => 'nutrition_diet_slider_section',
				'label'           => __( 'Show Hide Button', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => 'nutrition_diet_slider_dropdown',
			)
		)
	);
	$wp_customize->add_setting('nutrition_diet_slider_read_more',array(
		'default' => 'Book Your Free Slot',
		'sanitize_callback' => 'sanitize_text_field'
	)); 
	$wp_customize->add_control('nutrition_diet_slider_read_more',array(
		'label' => esc_html__('Button Text','nutrition-diet'),
		'section' => 'nutrition_diet_slider_section',
		'setting' => 'nutrition_diet_slider_read_more',
		'type'    => 'text',
		'active_callback' => 'nutrition_diet_slider_dropdown',
	));
	$wp_customize->add_setting( 'nutrition_diet_slider_content_alignment',
		array(
			'default' => 'LEFT-ALIGN',
			'transport' => 'refresh',
			'sanitize_callback' => 'nutrition_diet_sanitize_choices'
		)
	);
	$wp_customize->add_control( new Nutrition_Diet_Text_Radio_Button_Custom_Control( $wp_customize, 'nutrition_diet_slider_content_alignment',
		array(
			'type' => 'select',
			'label' => esc_html__( 'Slider Content Alignment', 'nutrition-diet' ),
			'section' => 'nutrition_diet_slider_section',
			'choices' => array(
				'LEFT-ALIGN' => __('LEFT','nutrition-diet'),
	            'CENTER-ALIGN' => __('CENTER','nutrition-diet'),
	            'RIGHT-ALIGN' => __('RIGHT','nutrition-diet'),
			),
			'active_callback' => 'nutrition_diet_slider_dropdown',
		)
	) );

	// About us
	$wp_customize->add_section( 'nutrition_diet_middle_section' , array(
		'title'      => __( 'About us Settings', 'nutrition-diet' ),
		'priority'   => 6,
		'panel' => 'nutrition_diet_custompage_panel',
	) );
	$wp_customize->add_setting( 'nutrition_diet_middle_section_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_middle_section_heading', array(
		'label'       => esc_html__( 'About Us Settings', 'nutrition-diet' ),		
		'section'     => 'nutrition_diet_middle_section',
		'settings'    => 'nutrition_diet_middle_section_heading',
	) ) );
	$wp_customize->add_setting(
		'nutrition_diet_about_enable',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_about_enable',
			array(
				'settings'        => 'nutrition_diet_about_enable',
				'section'         => 'nutrition_diet_middle_section',
				'label'           => __( 'Check To Show About Us Settings', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting('nutrition_diet_about_title',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('nutrition_diet_about_title',array(
		'label' => esc_html__('Title','nutrition-diet'),
		'section' => 'nutrition_diet_middle_section',
		'setting' => 'nutrition_diet_about_title',
		'type'    => 'text',
		'active_callback' => 'nutrition_diet_about_dropdown'
	));
	$wp_customize->selective_refresh->add_partial( 'nutrition_diet_about_title', array(
		'selector' => '.middle-sec-box h6',
		'render_callback' => 'nutrition_diet_customize_partial_nutrition_diet_about_title',
	) );
	$wp_customize->add_setting('nutrition_diet_middle_sec_page_settigs',array(
		'sanitize_callback' => 'nutrition_diet_sanitize_dropdown_pages',
	));
	$wp_customize->add_control('nutrition_diet_middle_sec_page_settigs',array(
		'type'    => 'dropdown-pages',
		'label' => __('Select Page','nutrition-diet'),
		'section' => 'nutrition_diet_middle_section',
		'active_callback' => 'nutrition_diet_about_dropdown'
	));
	$wp_customize->add_setting(
		'nutrition_diet_about_number',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_about_number',
			array(
				'settings'        => 'nutrition_diet_about_number',
				'section'         => 'nutrition_diet_middle_section',
				'label'           => __( 'Check To show box', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => 'nutrition_diet_about_dropdown',
			)
		)
	);
	$wp_customize->add_setting('nutrition_diet_calling_text',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('nutrition_diet_calling_text',array(
		'label' => esc_html__('Text','nutrition-diet'),
		'section' => 'nutrition_diet_middle_section',
		'setting' => 'nutrition_diet_calling_text',
		'type'    => 'text',
		'active_callback' => 'nutrition_diet_about_dropdown'
	));
	$wp_customize->add_setting('nutrition_diet_calling_number',array(
		'default' => '',
		'sanitize_callback' => 'nutrition_diet_sanitize_phone_number'
	));
	$wp_customize->add_control('nutrition_diet_calling_number',array(
		'label' => esc_html__('Phone Number','nutrition-diet'),
		'section' => 'nutrition_diet_middle_section',
		'setting' => 'nutrition_diet_calling_number',
		'type'    => 'text',
		'active_callback' => 'nutrition_diet_about_dropdown'
	));
	$wp_customize->selective_refresh->add_partial( 'nutrition_diet_calling_number', array(
		'selector' => '.top_bar i',
		'render_callback' => 'nutrition_diet_customize_partial_nutrition_diet_calling_number',
	) );
	$wp_customize->add_setting('nutrition_diet_about_button_2_text',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('nutrition_diet_about_button_2_text',array(
		'label' => esc_html__('Button 2 Text','nutrition-diet'),
		'section' => 'nutrition_diet_middle_section',
		'setting' => 'nutrition_diet_about_button_2_text',
		'type'    => 'text',
		'active_callback' => 'nutrition_diet_about_dropdown'
	));
	$wp_customize->add_setting('nutrition_diet_about_button_2_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw'
	));
	$wp_customize->add_control('nutrition_diet_about_button_2_link',array(
		'label' => esc_html__('Button 2 Link','nutrition-diet'),
		'section' => 'nutrition_diet_middle_section',
		'setting' => 'nutrition_diet_about_button_2_link',
		'type'    => 'text',
		'active_callback' => 'nutrition_diet_about_dropdown'
	));
	
	//Footer
    $wp_customize->add_section( 'nutrition_diet_footer_copyright', array(
    	'title'      => esc_html__( 'Footer Text', 'nutrition-diet' ),
    	'priority' => 7,
    	'panel' => 'nutrition_diet_custompage_panel',
	) );
	$wp_customize->add_setting( 'nutrition_diet_section_footer_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_footer_heading', array(
		'label'       => esc_html__( 'Footer Settings', 'nutrition-diet' ),		
		'section'     => 'nutrition_diet_footer_copyright',
		'settings'    => 'nutrition_diet_section_footer_heading',
		'priority' => 1,
	) ) );
    $wp_customize->add_setting('nutrition_diet_footer_text',array(
		'default'	=> 'Nutrition Diet WordPress Theme',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('nutrition_diet_footer_text',array(
		'label'	=> esc_html__('Copyright Text','nutrition-diet'),
		'section'	=> 'nutrition_diet_footer_copyright',
		'type'		=> 'textarea'
	));
	$wp_customize->selective_refresh->add_partial( 'nutrition_diet_footer_text', array(
		'selector' => '.site-info a',
		'render_callback' => 'nutrition_diet_customize_partial_nutrition_diet_footer_text',
	) );
	$wp_customize->add_setting( 'nutrition_diet_footer_content_alignment',
		array(
			'default' => 'CENTER-ALIGN',
			'transport' => 'refresh',
			'sanitize_callback' => 'nutrition_diet_sanitize_choices'
		)
	);
	$wp_customize->add_control( new Nutrition_Diet_Text_Radio_Button_Custom_Control( $wp_customize, 'nutrition_diet_footer_content_alignment',
		array(
			'type' => 'select',
			'label' => esc_html__( 'Footer Content Alignment', 'nutrition-diet' ),
			'section' => 'nutrition_diet_footer_copyright',
			'choices' => array(
				'LEFT-ALIGN' => __('LEFT','nutrition-diet'),
	            'CENTER-ALIGN' => __('CENTER','nutrition-diet'),
	            'RIGHT-ALIGN' => __('RIGHT','nutrition-diet'),
			),
			'active_callback' => '',
		)
	) );
	$wp_customize->add_setting( 'nutrition_diet_footer_widget',
		array(
			'default' => '4',
			'transport' => 'refresh',
			'sanitize_callback' => 'nutrition_diet_sanitize_choices'
		)
	);
	$wp_customize->add_control( new Nutrition_Diet_Text_Radio_Button_Custom_Control( $wp_customize, 'nutrition_diet_footer_widget',
		array(
			'type' => 'select',
			'label' => esc_html__('Footer Per Column','nutrition-diet'),
			'section' => 'nutrition_diet_footer_copyright',
			'choices' => array(
				'1' => __('1','nutrition-diet'),
	            '2' => __('2','nutrition-diet'),
	            '3' => __('3','nutrition-diet'),
	            '4' => __('4','nutrition-diet'),
			)
		)
	) );