/* global vivah_royal_weddingScreenReaderText */
/**
 * Theme functions file.
 *
 * Contains handlers for navigation and widget area.
 */

jQuery(function($){
	"use strict";
	jQuery('.main-menu-navigation > ul').superfish({
		delay:       500,                            
		animation:   {opacity:'show',height:'show'},  
		speed:       'fast'                        
	});

 	$( window ).scroll( function() {
		if ( $( this ).scrollTop() > 200 ) {
			$( '.back-to-top' ).addClass( 'show-back-to-top' );
		} else {
			$( '.back-to-top' ).removeClass( 'show-back-to-top' );
		}
	});

	// Click event to scroll to top.
	$( '.back-to-top' ).click( function() {
		$( 'html, body' ).animate( { scrollTop : 0 }, 500 );
		return false;
	});
});

function vivah_royal_wedding_open() {
	jQuery(".sidenav").addClass('show');
}
function vivah_royal_wedding_close() {
	jQuery(".sidenav").removeClass('show');
}

function vivah_royal_wedding_menuAccessibility() {
	var links, i, len,
	    vivah_royal_wedding_menu = document.querySelector( '.nav-menu' ),
	    vivah_royal_wedding_iconToggle = document.querySelector( '.nav-menu ul li:first-child a' );
    
	let vivah_royal_wedding_focusableElements = 'button, a, input';
	let vivah_royal_wedding_firstFocusableElement = vivah_royal_wedding_iconToggle; // get first element to be focused inside menu
	let vivah_royal_wedding_focusableContent = vivah_royal_wedding_menu.querySelectorAll(vivah_royal_wedding_focusableElements);
	let vivah_royal_wedding_lastFocusableElement = vivah_royal_wedding_focusableContent[vivah_royal_wedding_focusableContent.length - 1]; // get last element to be focused inside menu

	if ( ! vivah_royal_wedding_menu ) {
    	return false;
	}

	links = vivah_royal_wedding_menu.getElementsByTagName( 'a' );

	// Each time a menu link is focused or blurred, toggle focus.
	for ( i = 0, len = links.length; i < len; i++ ) {
	    links[i].addEventListener( 'focus', toggleFocus, true );
	    links[i].addEventListener( 'blur', toggleFocus, true );
	}

	// Sets or removes the .focus class on an element.
	function toggleFocus() {
      	var self = this;

      	// Move up through the ancestors of the current link until we hit .mobile-menu.
      	while (-1 === self.className.indexOf( 'nav-menu' ) ) {
	      	// On li elements toggle the class .focus.
	      	if ( 'li' === self.tagName.toLowerCase() ) {
	          	if ( -1 !== self.className.indexOf( 'focus' ) ) {
	          		self.className = self.className.replace( ' focus', '' );
	          	} else {
	          		self.className += ' focus';
	          	}
	      	}
	      	self = self.parentElement;
      	}
	}
    
	// Trap focus inside modal to make it ADA compliant
	document.addEventListener('keydown', function (e) {
	    let isTabPressed = e.key === 'Tab' || e.keyCode === 9;

	    if ( ! isTabPressed ) {
	    	return;
	    }

	    if ( e.shiftKey ) { // if shift key pressed for shift + tab combination
	      	if (document.activeElement === vivah_royal_wedding_firstFocusableElement) {
		        vivah_royal_wedding_lastFocusableElement.focus(); // add focus for the last focusable element
		        e.preventDefault();
	      	}
	    } else { // if tab key is pressed
	    	if (document.activeElement === vivah_royal_wedding_lastFocusableElement) { // if focused has reached to last focusable element then focus first focusable element after pressing tab
		      	vivah_royal_wedding_firstFocusableElement.focus(); // add focus for the first focusable element
		      	e.preventDefault();
	    	}
	    }
	});   
}

jQuery(function($){
	$('.mobile-menu').click(function () {
	    vivah_royal_wedding_menuAccessibility();
  	});
});