<?php
/**
 * vivah-royal-wedding: Customizer
 *
 * @subpackage vivah-royal-wedding
 * @since 1.0
 */

function vivah_royal_wedding_customize_register( $wp_customize ) {

	$wp_customize->add_setting('vivah_royal_wedding_logo_padding',array(
		'sanitize_callback'	=> 'esc_html'
	));
	$wp_customize->add_control('vivah_royal_wedding_logo_padding',array(
		'label' => __('Logo Padding','vivah-royal-wedding'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('vivah_royal_wedding_logo_top_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'vivah_royal_wedding_sanitize_float'
	));
	$wp_customize->add_control('vivah_royal_wedding_logo_top_padding',array(
		'type' => 'number',
		'description' => __('Top','vivah-royal-wedding'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('vivah_royal_wedding_logo_bottom_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'vivah_royal_wedding_sanitize_float'
	));
	$wp_customize->add_control('vivah_royal_wedding_logo_bottom_padding',array(
		'type' => 'number',
		'description' => __('Bottom','vivah-royal-wedding'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('vivah_royal_wedding_logo_left_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'vivah_royal_wedding_sanitize_float'
	));
	$wp_customize->add_control('vivah_royal_wedding_logo_left_padding',array(
		'type' => 'number',
		'description' => __('Left','vivah-royal-wedding'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('vivah_royal_wedding_logo_right_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'vivah_royal_wedding_sanitize_float'
	));
	$wp_customize->add_control('vivah_royal_wedding_logo_right_padding',array(
		'type' => 'number',
		'description' => __('Right','vivah-royal-wedding'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('vivah_royal_wedding_show_site_title',array(
		'default' => true,
		'sanitize_callback'	=> 'vivah_royal_wedding_sanitize_checkbox'
	));
	$wp_customize->add_control('vivah_royal_wedding_show_site_title',array(
		'type' => 'checkbox',
		'label' => __('Show / Hide Site Title','vivah-royal-wedding'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('vivah_royal_wedding_site_title_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'vivah_royal_wedding_sanitize_float'
	));
	$wp_customize->add_control('vivah_royal_wedding_site_title_font_size',array(
		'type' => 'number',
		'label' => __('Site Title Font Size','vivah-royal-wedding'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('vivah_royal_wedding_show_tagline',array(
		'default' => true,
		'sanitize_callback'	=> 'vivah_royal_wedding_sanitize_checkbox'
	));
	$wp_customize->add_control('vivah_royal_wedding_show_tagline',array(
		'type' => 'checkbox',
		'label' => __('Show / Hide Site Tagline','vivah-royal-wedding'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('vivah_royal_wedding_site_tagline_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'vivah_royal_wedding_sanitize_float'
	));
	$wp_customize->add_control('vivah_royal_wedding_site_tagline_font_size',array(
		'type' => 'number',
		'label' => __('Site Tagline Font Size','vivah-royal-wedding'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_panel( 'vivah_royal_wedding_panel_id', array(
	   'priority' => 10,
	   'capability' => 'edit_theme_options',
	   'theme_supports' => '',
	   'title' => __( 'Theme Settings', 'vivah-royal-wedding' ),
	   'description' => __( 'Description of what this panel does.', 'vivah-royal-wedding' ),
	) );

	$wp_customize->add_section( 'vivah_royal_wedding_theme_options_section', array(
    	'title'      => __( 'General Settings', 'vivah-royal-wedding' ),
		'priority'   => 30,
		'panel' => 'vivah_royal_wedding_panel_id'
	) );

	$wp_customize->add_setting('vivah_royal_wedding_blog_theme_options',array(
		'default' => 'One Column',
		'sanitize_callback' => 'vivah_royal_wedding_sanitize_choices'
	));
	$wp_customize->add_control('vivah_royal_wedding_blog_theme_options',array(
		'type' => 'select',
		'label' => __('Blog Page Sidebar Layout','vivah-royal-wedding'),
		'section' => 'vivah_royal_wedding_theme_options_section',
		'choices' => array(
		   'Left Sidebar' => __('Left Sidebar','vivah-royal-wedding'),
		   'Right Sidebar' => __('Right Sidebar','vivah-royal-wedding'),
		   'One Column' => __('One Column','vivah-royal-wedding'),
		   'Grid Layout' => __('Grid Layout','vivah-royal-wedding')
		),
	));

	$wp_customize->add_setting('vivah_royal_wedding_product_page_sidebar',array(
		'default' => 'Right Sidebar',
		'sanitize_callback' => 'vivah_royal_wedding_sanitize_choices'
	));
	$wp_customize->add_control('vivah_royal_wedding_product_page_sidebar',array(
        'type' => 'select',
        'label' => __('Product Page Sidebar Layout','vivah-royal-wedding'),
        'section' => 'vivah_royal_wedding_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','vivah-royal-wedding'),
            'Right Sidebar' => __('Right Sidebar','vivah-royal-wedding'),
            'One Column' => __('One Column','vivah-royal-wedding')
        ),
	));

	$wp_customize->add_setting('vivah_royal_wedding_archive_page_sidebar',array(
		'default' => 'One Column',
		'sanitize_callback' => 'vivah_royal_wedding_sanitize_choices'
	));
	$wp_customize->add_control('vivah_royal_wedding_archive_page_sidebar',array(
        'type' => 'select',
        'label' => __('Archive & Search Page Sidebar Layout','vivah-royal-wedding'),
        'section' => 'vivah_royal_wedding_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','vivah-royal-wedding'),
            'Right Sidebar' => __('Right Sidebar','vivah-royal-wedding'),
            'One Column' => __('One Column','vivah-royal-wedding'),
            'Grid Layout' => __('Grid Layout','vivah-royal-wedding')
        ),
	));

	//Header
	$wp_customize->add_section('vivah_royal_wedding_header',array(
		'title'	=> __('Header','vivah-royal-wedding'),
		'panel' => 'vivah_royal_wedding_panel_id',
	));

	$wp_customize->add_setting( 'vivah_royal_wedding_header_menu_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'vivah_royal_wedding_header_menu_color', array(
		'label' => 'Menus Color',
		'section' => 'vivah_royal_wedding_header',
	)));

	//Banner
	$wp_customize->add_section('vivah_royal_wedding_banner',array(
		'title'	=> __('Banner','vivah-royal-wedding'),
		'description'=> __('<b>Note :</b> This section will appear below general setting section','vivah-royal-wedding'),
		'panel' => 'vivah_royal_wedding_panel_id',
	));

	$wp_customize->add_setting('vivah_royal_wedding_show_banner',array(
		'default' => false,
		'sanitize_callback'	=> 'vivah_royal_wedding_sanitize_checkbox'
	));
	$wp_customize->add_control('vivah_royal_wedding_show_banner',array(
		'type' => 'checkbox',
		'label' => __('Show / Hide Banner','vivah-royal-wedding'),
		'section' => 'vivah_royal_wedding_banner'
	));

	for ( $count = 0; $count <= 0; $count++ ) {
		$wp_customize->add_setting( 'vivah_royal_wedding_page_settings' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'vivah_royal_wedding_sanitize_dropdown_pages'
		));
		$wp_customize->add_control( 'vivah_royal_wedding_page_settings' . $count, array(
			'label'    => __( 'Select Banner Page', 'vivah-royal-wedding' ),
			'description'=> __('Size of image should be 1675px x 555px','vivah-royal-wedding'),
			'section'  => 'vivah_royal_wedding_banner',
			'type'     => 'dropdown-pages'
		));
	}

	$wp_customize->add_setting( 'vivah_royal_wedding_slider_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	 ));
	 $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'vivah_royal_wedding_slider_color', array(
		'label' => 'Text Color',
		'section' => 'vivah_royal_wedding_banner',
	 )));

	 $wp_customize->add_setting( 'vivah_royal_wedding_sliderbdr_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	 ));
	 $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'vivah_royal_wedding_sliderbdr_color', array(
		'label' => 'Border Color',
		'section' => 'vivah_royal_wedding_banner',
	 )));

	 $wp_customize->add_setting( 'vivah_royal_wedding_sliderbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	 ));
	 $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'vivah_royal_wedding_sliderbg_color', array(
		'label' => 'Background Color',
		'section' => 'vivah_royal_wedding_banner',
	 )));

	//Bride And Groom
	$wp_customize->add_section('vivah_royal_wedding_our_services',array(
		'title'	=> __('Bride And Groom','vivah-royal-wedding'),
		'description'=> __('<b>Note :</b> This section will appear below the slider.','vivah-royal-wedding'),
		'panel' => 'vivah_royal_wedding_panel_id',
	));	

	$wp_customize->add_setting('vivah_royal_wedding_section_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('vivah_royal_wedding_section_title',array(
		'label'	=> __('Section Title','vivah-royal-wedding'),
		'section'=> 'vivah_royal_wedding_our_services',
		'setting'=> 'vivah_royal_wedding_section_title',
		'type'=> 'text'
	));

	for ( $count = 0; $count <= 1; $count++ ) {
		$wp_customize->add_setting( 'vivah_royal_wedding_services' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'vivah_royal_wedding_sanitize_dropdown_pages'
		));
		$wp_customize->add_control( 'vivah_royal_wedding_services' . $count, array(
			'label'    => __( 'Select Service Page', 'vivah-royal-wedding' ),
			'section'  => 'vivah_royal_wedding_our_services',
			'type'     => 'dropdown-pages'
		));
	}

	$wp_customize->add_setting('vivah_royal_wedding_brider_groom_section_padding',array(
      'default' => '',
      'sanitize_callback'	=> 'vivah_royal_wedding_sanitize_float'
   ));
   $wp_customize->add_control('vivah_royal_wedding_brider_groom_section_padding',array(
      'type' => 'number',
      'label' => __('Section Top Bottom Padding','vivah-royal-wedding'),
      'section' => 'vivah_royal_wedding_our_services',
   ));

   $wp_customize->add_setting( 'vivah_royal_wedding_service_color', array(
	'default' => '',
	'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'vivah_royal_wedding_service_color', array(
		'label' => 'Heading Color',
		'section' => 'vivah_royal_wedding_our_services',
	)));

	$wp_customize->add_setting( 'vivah_royal_wedding_servicetitle_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'vivah_royal_wedding_servicetitle_color', array(
		'label' => 'Title Color',
		'section' => 'vivah_royal_wedding_our_services',
	)));

	$wp_customize->add_setting( 'vivah_royal_wedding_servicetext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'vivah_royal_wedding_servicetext_color', array(
		'label' => 'Text Color',
		'section' => 'vivah_royal_wedding_our_services',
	)));

	//Footer
 	$wp_customize->add_section( 'vivah_royal_wedding_footer', array(
    	'title'      => __( 'Footer Text', 'vivah-royal-wedding' ),
		'priority'   => null,
		'panel' => 'vivah_royal_wedding_panel_id'
	) );

	$wp_customize->add_setting('vivah_royal_wedding_show_back_totop',array(
 		'default' => true,
   	'sanitize_callback'	=> 'vivah_royal_wedding_sanitize_checkbox'
	));
	$wp_customize->add_control('vivah_royal_wedding_show_back_totop',array(
   	'type' => 'checkbox',
   	'label' => __('Show / Hide Back to Top','vivah-royal-wedding'),
   	'section' => 'vivah_royal_wedding_footer'
	));

 	$wp_customize->add_setting('vivah_royal_wedding_footer_copy',array(
		'default'	=> 'Wedding WordPress Theme By Luzuk',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('vivah_royal_wedding_footer_copy',array(
		'label'	=> __('Footer Text','vivah-royal-wedding'),
		'section'	=> 'vivah_royal_wedding_footer',
		'setting'	=> 'vivah_royal_wedding_footer_copy',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('vivah_royal_wedding_footer_copylink',array(
		'default'	=> 'https://www.luzuk.com/themes/free-wedding-wordpress-theme/',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('vivah_royal_wedding_footer_copylink',array(
		'label'	=> __('Footer Link','vivah-royal-wedding'),
		'section'	=> 'vivah_royal_wedding_footer',
		'setting'	=> 'vivah_royal_wedding_footer_copylink',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('vivah_royal_wedding_copyright_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'vivah_royal_wedding_sanitize_float'
 	));
 	$wp_customize->add_control('vivah_royal_wedding_copyright_padding',array(
		'type' => 'number',
		'label' => __('Copyright Top Bottom Padding','vivah-royal-wedding'),
		'section' => 'vivah_royal_wedding_footer',
	));

	$wp_customize->add_setting( 'vivah_royal_wedding_copyright_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'vivah_royal_wedding_copyright_color', array(
		'label' => 'Text Color',
		'section' => 'vivah_royal_wedding_footer',
	)));

	$wp_customize->add_setting( 'vivah_royal_wedding_copyrightbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'vivah_royal_wedding_copyrightbg_color', array(
		'label' => 'Background Color',
		'section' => 'vivah_royal_wedding_footer',
	)));

	$wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport  = 'postMessage';

	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'render_callback' => 'vivah_royal_wedding_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'render_callback' => 'vivah_royal_wedding_customize_partial_blogdescription',
	) );
}
add_action( 'customize_register', 'vivah_royal_wedding_customize_register' );

function vivah_royal_wedding_customize_partial_blogname() {
	bloginfo( 'name' );
}

function vivah_royal_wedding_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

function vivah_royal_wedding_is_static_front_page() {
	return ( is_front_page() && ! is_home() );
}

function vivah_royal_wedding_is_view_with_layout_option() {
	// This option is available on all pages. It's also available on archives when there isn't a sidebar.
	return ( is_page() || ( is_archive() && ! is_active_sidebar( 'sidebar-1' ) ) );
}

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Vivah_Royal_Wedding_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Vivah_Royal_Wedding_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Vivah_Royal_Wedding_Customize_Section_Pro(
				$manager,
				'vivah_royal_wedding_example_1',
				array(
					'priority' => 9,
					'title'    => esc_html__( 'Wedding Pro', 'vivah-royal-wedding' ),
					'pro_text' => esc_html__( 'Go Pro','vivah-royal-wedding' ),
					'pro_url'  => esc_url( 'https://www.luzuk.com/product/wedding-wordpress-theme/' ),
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'vivah-royal-wedding-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'vivah-royal-wedding-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Vivah_Royal_Wedding_Customize::get_instance();