<?php
//about theme info
add_action( 'admin_menu', 'vivah_royal_wedding_gettingstarted' );
function vivah_royal_wedding_gettingstarted() {    	
	add_theme_page( esc_html__('About Theme', 'vivah-royal-wedding'), esc_html__('About Theme', 'vivah-royal-wedding'), 'edit_theme_options', 'vivah_royal_wedding_guide', 'vivah_royal_wedding_mostrar_guide');   
}

// Add a Custom CSS file to WP Admin Area
function vivah_royal_wedding_admin_theme_style() {
   wp_enqueue_style('custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/getting-started/getting-started.css');
}
add_action('admin_enqueue_scripts', 'vivah_royal_wedding_admin_theme_style');

//guidline for about theme
function vivah_royal_wedding_mostrar_guide() { 
	//custom function about theme customizer
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( 'vivah-royal-wedding' );

?>

<div class="wrapper-info">
	<div class="col-left">
		<div class="intro">
			<h3><?php esc_html_e( 'Welcome to Vivah Royal Wedding WordPress Theme', 'vivah-royal-wedding' ); ?> <span>Version: <?php echo esc_html($theme['Version']);?></span></h3>
		</div>
		<div class="started">
			<hr>
			<div class="free-doc">
				<div class="lz-4">
					<h4><?php esc_html_e( 'Start Customizing', 'vivah-royal-wedding' ); ?></h4>
					<ul>
						<span><?php esc_html_e( 'Go to', 'vivah-royal-wedding' ); ?> <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e( 'Customizer', 'vivah-royal-wedding' ); ?> </a> <?php esc_html_e( 'and start customizing your website', 'vivah-royal-wedding' ); ?></span>
					</ul>
				</div>
				<div class="lz-4">
					<h4><?php esc_html_e( 'Support', 'vivah-royal-wedding' ); ?></h4>
					<ul>
						<span><?php esc_html_e( 'Send your query to our', 'vivah-royal-wedding' ); ?> <a href="<?php echo esc_url( VIVAH_ROYAL_WEDDING_SUPPORT ); ?>" target="_blank"> <?php esc_html_e( 'Support', 'vivah-royal-wedding' ); ?></a></span>
					</ul>
				</div>
			</div>
			<p><?php esc_html_e( 'Vivah Royal Wedding, as the name suggests, is a royal theme for wedding websites to invite people to weddings and engagements. The aesthetically structured theme with a romantic feel is perfect for couples, with or without coding knowledge, looking for an easy-to-use, performance efficient theme to craft out a beautiful website. It can be used as a personal portfolio to show evergreen memorable journey of your love to your family and friends. Although it is essentially built as a wedding website, it can be bent to use for anniversaries, birthday parties and family functions. It is a highly user-friendly theme providing smooth navigation. It is responsive, cross-browser compatible, SEO-ready and social media integrated. The theme is translation ready enabling you to serve in your local language. With numerous options to change the layout of the theme like multiple blog and template layouts, boxed and full-width format, you can give a fresh look to your site without making a clicked design. It is made to load fast for better user experience. The use of banner and sliders will enhance the look of your site. Various sections are included in Vivah Royal Wedding like gallery, a separate section to introduce bridesmaid and groomsmen and posts to inform about other wedding events going to happen. With so many features bundled in one theme, make your wedding day even more special by designing a personal wedding website.', 'vivah-royal-wedding')?></p>
			<hr>			
			<div class="col-left-inner">
				<h3><?php esc_html_e( 'Get started with Free Vivah Royal Wedding Theme', 'vivah-royal-wedding' ); ?></h3>
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/customizer-image.png" alt="" />
			</div>
		</div>
	</div>
	<div class="col-right">
		<div class="col-left-area">
			<h3><?php esc_html_e('Premium Theme Information', 'vivah-royal-wedding'); ?></h3>
			<hr>
		</div>
		<div class="centerbold">
			<a href="<?php echo esc_url( VIVAH_ROYAL_WEDDING_LIVE_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'vivah-royal-wedding'); ?></a>
			<a href="<?php echo esc_url( VIVAH_ROYAL_WEDDING_BUY_NOW ); ?>"><?php esc_html_e('Buy Pro', 'vivah-royal-wedding'); ?></a>
			<a href="<?php echo esc_url( VIVAH_ROYAL_WEDDING_PRO_DOCS ); ?>" target="_blank"><?php esc_html_e('Pro Documentation', 'vivah-royal-wedding'); ?></a>
			<hr class="secondhr">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/vivah.jpg" alt="" />
		</div>
		<h3><?php esc_html_e( 'PREMIUM THEME FEATURES', 'vivah-royal-wedding'); ?></h3>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon01.png" alt="" />
			<h4><?php esc_html_e( 'Banner Slider', 'vivah-royal-wedding'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon02.png" alt="" />
			<h4><?php esc_html_e( 'Theme Options', 'vivah-royal-wedding'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon03.png" alt="" />
			<h4><?php esc_html_e( 'Custom Innerpage Banner', 'vivah-royal-wedding'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon04.png" alt="" />
			<h4><?php esc_html_e( 'Custom Colors and Images', 'vivah-royal-wedding'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon05.png" alt="" />
			<h4><?php esc_html_e( 'Fully Responsive', 'vivah-royal-wedding'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon06.png" alt="" />
			<h4><?php esc_html_e( 'Hide/Show Sections', 'vivah-royal-wedding'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon07.png" alt="" />
			<h4><?php esc_html_e( 'Woocommerce Support', 'vivah-royal-wedding'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon08.png" alt="" />
			<h4><?php esc_html_e( 'Limit to display number of Posts', 'vivah-royal-wedding'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon09.png" alt="" />
			<h4><?php esc_html_e( 'Multiple Page Templates', 'vivah-royal-wedding'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon10.png" alt="" />
			<h4><?php esc_html_e( 'Custom Read More link', 'vivah-royal-wedding'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon11.png" alt="" />
			<h4><?php esc_html_e( 'Code written with WordPress standard', 'vivah-royal-wedding'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon12.png" alt="" />
			<h4><?php esc_html_e( '100% Multi language', 'vivah-royal-wedding'); ?></h4>
		</div>
	</div>
</div>
<?php } ?>