<?php
/**
 * Template part for displaying posts
 * 
 * @subpackage vivah-royal-wedding
 * @since 1.0
 * @version 1.4
 */

?>
<div id="post-<?php the_ID(); ?>" <?php post_class('inner-service'); ?>>
  <div class="article_content">
    <?php the_post_thumbnail(); ?>
    <div class="article-text">
      <i class="far fa-calendar-alt"></i><span class="entry-date"><?php the_time( get_option( 'date_format' ) ); ?></span>
      <h1><?php the_title(); ?></h1>
      <div class="text-content"><p><?php the_content(); ?></p></div>
      <div class="row">
        <div class="col-lg-6 col-offset-lg-6 col-md-6 col-offset-md-6 ">
          <div class="metabox">
            <i class="fas fa-user"></i><span class="entry-author"><?php the_author(); ?></span>
            <i class="fas fa-comments"></i><span class="entry-comments"><?php comments_number( __('0 Comments','vivah-royal-wedding'), __('0 Comments','vivah-royal-wedding'), __('% Comments','vivah-royal-wedding') ); ?></span>
      	  </div>
        </div>
      </div>
    </div>
    <div class="clearfix"></div> 
  </div><hr class="horizontal">
</div>