<?php
function expert_gamer_general_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'expert_gamer_general', array(
			'priority' => 31,
			'title' => esc_html__( 'General', 'expert-gamer' ),
		)
	);

	/*=========================================
	Breadcrumb  Section
	=========================================*/
	$wp_customize->add_section(
		'expert_gamer_breadcrumb_setting', array(
			'title' => esc_html__( 'Breadcrumb Section', 'expert-gamer' ),
			'priority' => 1,
			'panel' => 'expert_gamer_general',
		)
	);
	
	// Settings 
	$wp_customize->add_setting(
		'expert_gamer_breadcrumb_settings'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'expert_gamer_sanitize_text',
			'priority' => 1,
		)
	);

	$wp_customize->add_control(
	'expert_gamer_breadcrumb_settings',
		array(
			'type' => 'hidden',
			'label' => __('Settings','expert-gamer'),
			'section' => 'expert_gamer_breadcrumb_setting',
		)
	);
	
	// Breadcrumb Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_hs_breadcrumb' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_hs_breadcrumb', 
		array(
			'label'	      => esc_html__( 'Hide / Show Section', 'expert-gamer' ),
			'section'     => 'breadcrumb_setting',
			'settings'    => 'expert_gamer_hs_breadcrumb',
			'type'        => 'checkbox'
		) 
	);

	/*=========================================
	Preloader Section
	=========================================*/
	$wp_customize->add_section(
		'expert_gamer_preloader_section_setting', array(
			'title' => esc_html__( 'Preloader', 'expert-gamer' ),
			'priority' => 3,
			'panel' => 'expert_gamer_general',
		)
	);

	// Preloader Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_preloader_setting' , 
			array(
			'default' => '',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_preloader_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Preloader', 'expert-gamer' ),
			'section'     => 'expert_gamer_preloader_section_setting',
			'settings'    => 'expert_gamer_preloader_setting',
			'type'        => 'checkbox'
		) 
	);

	/*=========================================
	Scroll To Top Section
	=========================================*/
	$wp_customize->add_section(
		'expert_gamer_scroll_to_top_section_setting', array(
			'title' => esc_html__( 'Scroll To Top', 'expert-gamer' ),
			'priority' => 3,
			'panel' => 'expert_gamer_general',
		)
	);

	// Scroll To Top Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_expert_gamer_scroll_top_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_scroll_top_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Scroll To Top', 'expert-gamer' ),
			'section'     => 'expert_gamer_scroll_to_top_section_setting',
			'settings'    => 'expert_gamer_expert_gamer_scroll_top_setting',
			'type'        => 'checkbox'
		) 
	);

	/*=========================================
	Woocommerce Section
	=========================================*/
	$wp_customize->add_section(
		'woocommerce_section_setting', array(
			'title' => esc_html__( 'Woocommerce Settings', 'expert-gamer' ),
			'priority' => 3,
			'panel' => 'expert_gamer_general',
		)
	);

	$wp_customize->add_setting(
    	'expert_gamer_custom_shop_per_columns',
    	array(
			'default' => '3',
			'sanitize_callback' => 'expert_gamer_sanitize_phone_number',
		)
	);	
	$wp_customize->add_control( 
		'expert_gamer_custom_shop_per_columns',
		array(
		    'label'   		=> __('Product Per Columns','expert-gamer'),
		    'section'		=> 'woocommerce_section_setting',
			'type' 			=> 'number',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting(
    	'expert_gamer_custom_shop_product_per_page',
    	array(
			'default' => '9',
			'sanitize_callback' => 'expert_gamer_sanitize_phone_number',
		)
	);	
	$wp_customize->add_control( 
		'expert_gamer_custom_shop_product_per_page',
		array(
		    'label'   		=> __('Product Per Page','expert-gamer'),
		    'section'		=> 'woocommerce_section_setting',
			'type' 			=> 'number',
			'transport'         => $selective_refresh,
		)  
	);

	// Woocommerce Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_wocommerce_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_wocommerce_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Woocommerce Sidebar', 'expert-gamer' ),
			'section'     => 'woocommerce_section_setting',
			'settings'    => 'expert_gamer_wocommerce_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	/*=========================================
	Sticky Header Section
	=========================================*/
	$wp_customize->add_section(
		'sticky_header_section_setting', array(
			'title' => esc_html__( 'Sticky Header Settings', 'expert-gamer' ),
			'priority' => 3,
			'panel' => 'expert_gamer_general',
		)
	);

	// Sticky Header Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_sticky_header' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_sticky_header', 
		array(
			'label'	      => esc_html__( 'Hide / Show Sticky Header', 'expert-gamer' ),
			'section'     => 'sticky_header_section_setting',
			'settings'    => 'expert_gamer_sticky_header',
			'type'        => 'checkbox'
		) 
	);
}

add_action( 'customize_register', 'expert_gamer_general_setting' );