<?php
function expert_gamer_post_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'expert_gamer_post', array(
			'priority' => 31,
			'title' => esc_html__( 'Post Option', 'expert-gamer' ),
		)
	);

	/*=========================================
	Archive Post  Section
	=========================================*/
	$wp_customize->add_section(
		'archive_post_setting', array(
			'title' => esc_html__( 'Archive Post', 'expert-gamer' ),
			'priority' => 1,
			'panel' => 'expert_gamer_post',
		)
	);
	
	// Archive Post Settings 
	$wp_customize->add_setting(
		'archive_post_settings'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'expert_gamer_sanitize_text',
			'priority' => 1,
		)
	);

	$wp_customize->add_control(
	'archive_post_settings',
		array(
			'type' => 'hidden',
			'label' => __('Archive Post Section Setting','expert-gamer'),
			'section' => 'archive_post_setting',
		)
	);

	// Layouts Post
	$wp_customize->add_setting('expert_gamer_blog_layout_option_setting',array(
	  'default' => 'Default',
	  'sanitize_callback' => 'expert_gamer_sanitize_choices'
	));
	$wp_customize->add_control(new Expert_Gamer_Image_Radio_Control($wp_customize, 'expert_gamer_blog_layout_option_setting', array(
	  'type' => 'select',
	  'label' => __('Blog Post Layouts','expert-gamer'),
	  'section' => 'archive_post_setting',
	  'choices' => array(
	      'Default' => esc_url(get_template_directory_uri()).'/assets/images/layout-1.png',
	      'Left' => esc_url(get_template_directory_uri()).'/assets/images/layout-2.png',
	))));
	
	// Post Heading Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_post_heading_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_post_heading_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Heading', 'expert-gamer' ),
			'section'     => 'archive_post_setting',
			'settings'    => 'expert_gamer_post_heading_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Content Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_post_content_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_post_content_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Content', 'expert-gamer' ),
			'section'     => 'archive_post_setting',
			'settings'    => 'expert_gamer_post_content_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Featured Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_post_featured_image_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_post_featured_image_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Feature Image', 'expert-gamer' ),
			'section'     => 'archive_post_setting',
			'settings'    => 'expert_gamer_post_featured_image_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_post_date_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_post_date_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Date', 'expert-gamer' ),
			'section'     => 'archive_post_setting',
			'settings'    => 'expert_gamer_post_date_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_post_comments_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_post_comments_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Comment', 'expert-gamer' ),
			'section'     => 'archive_post_setting',
			'settings'    => 'expert_gamer_post_comments_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_post_author_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_post_author_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Author', 'expert-gamer' ),
			'section'     => 'archive_post_setting',
			'settings'    => 'expert_gamer_post_author_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Tags Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_post_tags_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_post_tags_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Tags', 'expert-gamer' ),
			'section'     => 'archive_post_setting',
			'settings'    => 'expert_gamer_post_tags_settings',
			'type'        => 'checkbox'
		) 
	);


	/*=========================================
	Single Post  Section
	=========================================*/
	$wp_customize->add_section(
		'expert_gamer_single_post', array(
			'title' => esc_html__( 'Single Post', 'expert-gamer' ),
			'priority' => 3,
			'panel' => 'expert_gamer_post',
		)
	);
	
	// Post Heading Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_single_post_heading_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_single_post_heading_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Heading', 'expert-gamer' ),
			'section'     => 'expert_gamer_single_post',
			'settings'    => 'expert_gamer_single_post_heading_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Content Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_single_post_content_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_single_post_content_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Content', 'expert-gamer' ),
			'section'     => 'expert_gamer_single_post',
			'settings'    => 'expert_gamer_single_post_content_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Featured Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_single_post_featured_image_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_single_post_featured_image_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Feature Image', 'expert-gamer' ),
			'section'     => 'expert_gamer_single_post',
			'settings'    => 'expert_gamer_single_post_featured_image_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_single_post_date_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_single_post_date_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Date', 'expert-gamer' ),
			'section'     => 'expert_gamer_single_post',
			'settings'    => 'expert_gamer_single_post_date_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_single_post_comments_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_single_post_comments_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Comment', 'expert-gamer' ),
			'section'     => 'expert_gamer_single_post',
			'settings'    => 'expert_gamer_single_post_comments_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_single_post_author_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_single_post_author_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Author', 'expert-gamer' ),
			'section'     => 'expert_gamer_single_post',
			'settings'    => 'expert_gamer_single_post_author_settings',
			'type'        => 'checkbox'
		) 
	);
	// Post Tags Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_single_post_tags_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_single_post_tags_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Tags', 'expert-gamer' ),
			'section'     => 'expert_gamer_single_post',
			'settings'    => 'expert_gamer_single_post_tags_settings',
			'type'        => 'checkbox'
		) 
	);
}

add_action( 'customize_register', 'expert_gamer_post_setting' );