<?php 
  $expert_gamer_latest_release = get_theme_mod('expert_gamer_latest_release_setting','1');
  
  if($expert_gamer_latest_release == '1') {
?>
<section id="latest-release" class="py-5">
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-4 col-md-4 col-sm-4">
        <?php if( get_theme_mod( 'expert_gamer_latest_release_heading' ) != '') { ?>
          <h2><?php echo esc_html(get_theme_mod('expert_gamer_latest_release_heading')); ?></h2>
        <?php }?>
        <?php if( get_theme_mod( 'expert_gamer_latest_release_sub_heading' ) != '') { ?>
          <p class="mb-0"><?php echo esc_html(get_theme_mod('expert_gamer_latest_release_sub_heading')); ?></p>
        <?php }?>
      </div>
      <div class="col-lg-8 col-md-8 col-sm-8">
        <div class="pull-up-box">
          <div class="owl-carousel">
            <?php
              $expert_gamer_post_category = get_theme_mod('expert_gamer_latest_release_section_category');
              if($expert_gamer_post_category){
                $expert_gamer_page_query = new WP_Query(array( 'category_name' => esc_html( $expert_gamer_post_category ,'expert-gamer')));?>
                <?php while( $expert_gamer_page_query->have_posts() ) : $expert_gamer_page_query->the_post(); ?>
                <div class="box">
                  <?php if(has_post_thumbnail()) { ?><?php the_post_thumbnail(); ?><?php } ?>
                  <div class="box-content">
                    <a href="<?php the_permalink(); ?>"><h3 class="title"><?php the_title(); ?></h3></a>
                    
                    <p class="post mb-0"><?php echo wp_trim_words( get_the_content(),10 );?></p>
                  </div>
                </div>
                <?php endwhile;
                wp_reset_postdata();
              }
            ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<?php } ?>