<?php 
  $expert_gamer_slider = get_theme_mod('expert_gamer_slider_setting','1');
  $expert_gamer_slider_button = get_theme_mod('expert_gamer_slider_button_setting','1');
  
  if($expert_gamer_slider == '1') {
?>
<section id="slider-section" class="slider-area home-slider">
  <div class="topbar-home">
    <?php get_template_part( 'template-parts/sections/section-header-home' ); ?>
  </div>
  <!-- start of hero -->
  <div id="carouselExampleInterval" class="carousel slide" data-bs-ride="carousel">
    <?php $expert_gamer_pages = array();
      for ( $count = 1; $count <= 3; $count++ ) {
        $mod = intval( get_theme_mod( 'expert_gamer_slider' . $count ));
        if ( 'page-none-selected' != $mod ) {
          $expert_gamer_pages[] = $mod;
        }
      }
      if( !empty($expert_gamer_pages) ) :
        $args = array(
          'post_type' => 'page',
          'post__in' => $expert_gamer_pages,
          'orderby' => 'post__in'
        );
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) :
          $i = 1;
    ?>
    <div class="carousel-inner" role="listbox">
      <?php while ( $query->have_posts() ) : $query->the_post(); ?>
        <div <?php if($i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>
          <?php if(has_post_thumbnail()){ ?>
            <img src="<?php the_post_thumbnail_url('full'); ?>"/>
          <?php }else { ?><div class="slider-color-box"></div> <?php } ?>
          <div class="carousel-caption">
            <div class="inner_carousel">
              <?php if( get_theme_mod( 'expert_gamer_slider_top_content' ) != '') { ?>
                <p><?php echo esc_html( get_theme_mod('expert_gamer_slider_top_content','')); ?></p>
              <?php }?>
              <h2><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
              <?php if($expert_gamer_slider_button == '1') { ?>
                <div class="read-btn">
                  <a href="<?php the_permalink(); ?>"><?php echo esc_html('READ MORE','expert-gamer'); ?></a>
                </div>
             <?php } ?>
            </div>
          </div>
        </div>
      <?php $i++; endwhile; 
      wp_reset_postdata();?>
    </div>
    <?php else : ?>
      <div class="no-postfound"></div>
    <?php endif;
    endif;?>
    <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleInterval" id="prev" data-bs-slide="prev">
    <i class="fas fa-arrow-left"></i>
    <span class="screen-reader-text"><?php echo esc_html('Previous','expert-gamer'); ?></span>
    </button>
    <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleInterval" data-bs-slide="next" id="next">
    <i class="fas fa-arrow-right"></i>
    <span class="screen-reader-text"><?php echo esc_html('Next','expert-gamer'); ?></span>
    </button>
  </div>
  <!-- end of hero slider -->
</section>
<?php } ?>