<?php
/**
 *
 * Adds custom Block Patterns to the post/page editor.
 *
 * see: https://developer.wordpress.org/block-editor/developers/block-api/block-patterns/
 *
 * @package Didi Lite
 */


register_block_pattern_category(
	'didi-lite-theme',
	array( 'label' => esc_html__( 'Didi Lite', 'didi-lite' ) )
);


register_block_pattern_category(
	'didi-lite-theme-wc',
	array( 'label' => esc_html__( 'Didi Lite - Products', 'didi-lite' ) )
);

register_block_pattern(
	'didi-lite/didi-lite-hero',
	array(
		'title'			=> esc_html__( 'Hero Section', 'didi-lite' ),
		'description'	=> esc_html_x( 'A pattern to quickly create the top hero section.', 'Block pattern description', 'didi-lite' ),

		'content'		=> '<!-- wp:cover {"url":"' . esc_url( get_theme_file_uri( 'images/hero.jpg' ) ) . '","hasParallax":true,"minHeight":700,"align":"center","className":"is-style-editorskit-diagonal"} -->
        <div class="wp-block-cover aligncenter has-background-dim has-parallax hero-image" style="background-image:url(' . esc_url( get_theme_file_uri( 'images/hero.jpg' ) ) . ');min-height:700px"><div class="wp-block-cover__inner-container"><!-- wp:paragraph -->
        <p></p>
        <!-- /wp:paragraph -->

        <!-- wp:group -->
        <div class="wp-block-group has-background"><div class="wp-block-group__inner-container"><!-- wp:heading {"textAlign":"center","level":1,"style":{"typography":{"fontSize":93}}} -->
        <h1 class="has-text-align-center" style="font-size:93px">' . esc_html_x( 'Fashion & Style', 'Theme starter content', 'didi-lite' ) . '</h1>
        <!-- /wp:heading -->
        
        <!-- wp:paragraph {"align":"center"} -->
        <p class="has-text-align-center">' . esc_html_x( 'Little Didi Lite Book *NEW - Lifestyle and Fashion Stories', 'Theme starter content', 'didi-lite' ) . '</p>
        <!-- /wp:paragraph -->
        
        <!-- wp:buttons {"contentJustification":"center"} -->
        <div class="wp-block-buttons is-content-justification-center"><!-- wp:button {"style":{"color":{"text":"#000000"}},"backgroundColor":"yellow"} -->
        <div class="wp-block-button"><a class="wp-block-button__link has-yellow-background-color has-text-color has-background" style="color:#000000">' . esc_html_x( 'Read More', 'Theme starter content', 'didi-lite' ) . '</a></div>
        <!-- /wp:button --></div>
        <!-- /wp:buttons --></div></div>
        <!-- /wp:group --></div></div>
        <!-- /wp:cover -->',

		'viewportWidth'	=> 1400,
		'categories'	=> array( 'didi-lite-theme' ),
	)
);

register_block_pattern(
	'didi-lite/didi-lite-text-image',
	array(
		'title'			=> esc_html__( '2 Columns - Text and Image', 'didi-lite' ),
		'description'	=> esc_html_x( 'A pattern to quickly create 2 columns with text and image.', 'Block pattern description', 'didi-lite' ),

		'content'		=> '<!-- wp:columns {"className":"has-2-columns"} -->
        <div class="wp-block-columns has-2-columns"><!-- wp:column -->
        <div class="wp-block-column"><!-- wp:heading {"fontSize":"large"} -->
        <h2 class="has-large-font-size">' . esc_html_x( 'Love for Fashion', 'Theme starter content', 'didi-lite' ) . '</h2>
        <!-- /wp:heading -->
        
        <!-- wp:paragraph -->
        <p>' . esc_html_x( 'Malesuada nibh montes fusce cum eleifend fringilla commodo mattis tempor platea montes. Commodo metus adipiscing odio.', 'Theme starter content', 'didi-lite' ) . '</p>
        <!-- /wp:paragraph -->
        
        <!-- wp:list {"className":"styled"} -->
        <ul class="styled"><li><strong>' . esc_html_x( 'Fashion', 'Theme starter content', 'didi-lite' ) . '</strong>&nbsp;–&nbsp;<em>' . esc_html_x( 'Malesuada nibh montes fusce cum eleifend fringilla.', 'Theme starter content', 'didi-lite' ) . '</em></li><li><strong>' . esc_html_x( 'Style', 'Theme starter content', 'didi-lite' ) . '</strong>&nbsp;–&nbsp;<em>' . esc_html_x( 'Malesuada nibh montes fusce cum eleifend fringilla.', 'Theme starter content', 'didi-lite' ) . '</em></li></ul>
        <!-- /wp:list -->
        
        <!-- wp:button {"align":"left"} -->
        <div class="wp-block-button alignleft"><a class="wp-block-button__link" href="https://anarieldesign.com/themedemos/didi-lite/">' . esc_html_x( 'Read More', 'Theme starter content', 'didi-lite' ) . '</a></div>
        <!-- /wp:button --></div>
        <!-- /wp:column -->
        
        <!-- wp:column -->
        <div class="wp-block-column"><!-- wp:image -->
        <figure class="wp-block-image"><img src="' . esc_url( get_theme_file_uri( 'images/cover-image.jpg' ) ) . '" alt="image" class=""/></figure>
        <!-- /wp:image --></div>
        <!-- /wp:column --></div>
        <!-- /wp:columns -->',

		'viewportWidth'	=> 1400,
		'categories'	=> array( 'didi-lite-theme' ),
	)
);

register_block_pattern(
	'didi-lite/didi-lite-recent-post',
	array(
		'title'			=> esc_html__( 'Recent Post Grid', 'didi-lite' ),
		'description'	=> esc_html_x( 'A pattern to quickly create 3 column recent post.', 'Block pattern description', 'didi-lite' ),

		'content'		=> '<!-- wp:heading {"fontSize":"large"} -->
        <h2 class="has-large-font-size">' . esc_html_x( 'Latest Posts', 'Theme starter content', 'didi-lite' ) . '</h3>
        <!-- /wp:heading -->
        
        <!-- wp:spacer {"height":10} -->
        <div style="height:10px" aria-hidden="true" class="wp-block-spacer"></div>
        <!-- /wp:spacer -->
        
        <!-- wp:columns {"className":"didi-lite-post has-3-columns recent-post-standard"} -->
        <div class="wp-block-columns didi-lite-post has-3-columns recent-post-standard"><!-- wp:column -->
        <div class="wp-block-column"><!-- wp:image {"linkDestination":"custom","className":"ticss-5a1ad9a0"} -->
        <figure class="wp-block-image ticss-5a1ad9a0"><a href="#"><img src="' . esc_url( get_theme_file_uri( 'images/post-1.jpg' ) ) . '" alt="image" class=""/></a></figure>
        <!-- /wp:image -->
        
        <!-- wp:latest-posts {"postsToShow":1,"displayPostContent":true,"displayPostDate":true} /--></div>
        <!-- /wp:column -->
        
        <!-- wp:column -->
        <div class="wp-block-column"><!-- wp:image {"linkDestination":"custom","className":"ticss-5a1ad9a0"} -->
        <figure class="wp-block-image ticss-5a1ad9a0"><a href="#"><img src="' . esc_url( get_theme_file_uri( 'images/post-2.jpg' ) ) . '" alt="image" class=""/></a></figure>
        <!-- /wp:image -->
        
        <!-- wp:latest-posts {"postsToShow":1,"displayPostContent":true,"displayPostDate":true} /--></div>
        <!-- /wp:column -->
        
        <!-- wp:column -->
        <div class="wp-block-column"><!-- wp:image {"linkDestination":"custom","className":"ticss-5a1ad9a0"} -->
        <figure class="wp-block-image ticss-5a1ad9a0"><a href="#"><img src="' . esc_url( get_theme_file_uri( 'images/post-3.jpg' ) ) . '" alt="image" class=""/></a></figure>
        <!-- /wp:image -->
        
        <!-- wp:latest-posts {"postsToShow":1,"displayPostContent":true,"displayPostDate":true} /--></div>
        <!-- /wp:column --></div>
        <!-- /wp:columns -->',

		'viewportWidth'	=> 1400,
		'categories'	=> array( 'didi-lite-theme' ),
	)
);

register_block_pattern(
	'didi-lite/didi-lite-team',
	array(
		'title'			=> esc_html__( 'Team', 'didi-lite' ),
		'description'	=> esc_html_x( 'A pattern to quickly create team block.', 'Block pattern description', 'didi-lite' ),

		'content'		=> '<!-- wp:columns {"className":"has-3-columns"} -->
        <div class="wp-block-columns has-3-columns"><!-- wp:column -->
        <div class="wp-block-column"><!-- wp:image -->
        <figure class="wp-block-image"><img src="' . esc_url( get_theme_file_uri( 'images/team-1.jpg' ) ) . '" alt="image" class=""/></figure>
        <!-- /wp:image -->
        
        <!-- wp:heading {"align":"left","level":3} -->
        <h3 class="has-text-align-left">' . esc_html_x( 'Angela Ema', 'Theme starter content', 'didi-lite' ) . '</h3>
        <!-- /wp:heading -->
        
        <!-- wp:paragraph -->
        <p><em>' . esc_html_x( 'CEO/Founder', 'Theme starter content', 'didi-lite' ) . '</em></p>
        <!-- /wp:paragraph -->
        
        <!-- wp:paragraph -->
        <p>' . esc_html_x( 'Malesuada nibh montes fusce cum eleifend fringilla commodo mattis tempor platea montes. Malesuada nibh montes fusce cum eleifend. Malesuada nibh montes fusce cum eleifend fringilla commodo mattis tempor platea montes.', 'Theme starter content', 'didi-lite' ) . '</p>
        <!-- /wp:paragraph --></div>
        <!-- /wp:column -->
        
        <!-- wp:column -->
        <div class="wp-block-column"><!-- wp:image -->
        <figure class="wp-block-image"><img src="' . esc_url( get_theme_file_uri( 'images/team-2.jpg' ) ) . '" alt="image" class=""/></figure>
        <!-- /wp:image -->
        
        <!-- wp:heading {"align":"left","level":3} -->
        <h3 class="has-text-align-left">' . esc_html_x( 'Alex Zela', 'Theme starter content', 'didi-lite' ) . '</h3>
        <!-- /wp:heading -->
        
        <!-- wp:paragraph -->
        <p><em>' . esc_html_x( 'Volunteer', 'Theme starter content', 'didi-lite' ) . '</em></p>
        <!-- /wp:paragraph -->
        
        <!-- wp:paragraph -->
        <p>' . esc_html_x( 'Malesuada nibh montes fusce cum eleifend fringilla commodo mattis tempor platea montes. Malesuada nibh montes fusce cum eleifend. Malesuada nibh montes fusce cum eleifend fringilla commodo mattis tempor platea montes.', 'Theme starter content', 'didi-lite' ) . '</p>
        <!-- /wp:paragraph --></div>
        <!-- /wp:column -->
        
        <!-- wp:column -->
        <div class="wp-block-column"><!-- wp:image -->
        <figure class="wp-block-image"><img src="' . esc_url( get_theme_file_uri( 'images/team-3.jpg' ) ) . '" alt="image" class=""/></figure>
        <!-- /wp:image -->
        
        <!-- wp:heading {"align":"left","level":3} -->
        <h3 class="has-text-align-left">' . esc_html_x( 'Talinka Bubi', 'Theme starter content', 'didi-lite' ) . '</h3>
        <!-- /wp:heading -->
        
        <!-- wp:paragraph -->
        <p><em>' . esc_html_x( 'Manager', 'Theme starter content', 'didi-lite' ) . '</em></p>
        <!-- /wp:paragraph -->
        
        <!-- wp:paragraph -->
        <p>' . esc_html_x( 'Malesuada nibh montes fusce cum eleifend fringilla commodo mattis tempor platea montes. Malesuada nibh montes fusce cum eleifend. Malesuada nibh montes fusce cum eleifend fringilla commodo mattis tempor platea montes.', 'Theme starter content', 'didi-lite' ) . '</p>
        <!-- /wp:paragraph --></div>
        <!-- /wp:column --></div>
        <!-- /wp:columns -->',

		'viewportWidth'	=> 1400,
		'categories'	=> array( 'didi-lite-theme' ),
	)
);