# Contributing to MyStyle

There are many ways to contribute to the MyStyle project!

- Translating strings into your language.
- Answering questions on GitHub and within the various MyStyle communities.
- Submitting fixes, improvements, and enhancements.

Your help making MyStyle even better is greatly appreciated :)

If you think something can be improved and you wish to contribute code,
[fork](https://help.github.com/articles/fork-a-repo/) MyStyle, commit your changes,
and [send a pull request](https://help.github.com/articles/using-pull-requests/). We'll be happy to review your changes!

## Feature Requests

Feature requests can be [submitted to our issue tracker](https://github.com/mystyle-platform/mystyle-wp-custom-product-designer/issues/new?template=Feature_request.md). Be sure to include a description of the expected behavior and use case, and before submitting a request, please search for similar ones in the closed issues.

Feature request issues will remain closed until we see sufficient interest via comments and [👍 reactions](https://help.github.com/articles/about-discussions-in-issues-and-pull-requests/) from the community.

You can see a [list of current feature requests which require votes here](https://github.com/mystyle-platform/mystyle-wp-custom-product-designer/issues?q=label%3A%22votes+needed%22+label%3Aenhancement+sort%3Areactions-%2B1-desc+is%3Aclosed).

## Technical Support / Questions

We don't offer technical support on GitHub, instead please go to our support site
at: https://www.mystyleplatform.com/support/.

## Coding Guidelines

- **Ensure you stick to the [WordPress Coding Standards](https://make.wordpress.org/core/handbook/best-practices/coding-standards/php/)**
- Install [PHP_CodeSniffer](https://github.com/squizlabs/PHP_CodeSniffer). It'll help with the Coding Standards.
- Ensure you use LF line endings in your code editor. Use [EditorConfig](http://editorconfig.org/) if your editor supports it so that indentation, line endings and other settings are auto configured.
- When committing, reference your issue number (#1234) and include a note about the fix.
- Ensure that your code is compatible with PHP 5.2+.
- Push the changes to your fork and submit a pull request on the master branch of the MyStyle repository. Existing maintenance branches will be maintained by MyStyle developers.

Please **don't** modify the changelog or update the .pot files. These are maintained by the MyStyle team.
